package com.jhscale.common.exception;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.em.ServerExp;
import com.jhscale.common.model.exp.ExpKVModel;

/**
 * @author lie_w
 * @title: WarningException
 * @projectName common
 * @description: 警告异常
 * @date 2022/8/1119:15
 */
public class WarningException extends ProfessionalException {
    /**
     * @description: 异常等级
     **/
    @Override
    public String getExpLevel() {
        return JHContents.WARNING;
    }

    /**
     * Constructs a new exception with {@code null} as its detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param code
     * @param messages
     */
    public WarningException(String code, String... messages) {
        super(code, messages);
    }

    public WarningException(String code, String message) {
        super(code, message);
    }

    public WarningException(String code, ExpKVModel... models) {
        super(code, models);
    }

    public WarningException(String code, Object... objects) {
        super(code, objects);
    }

    public WarningException(ServerExp serverExp) {
        super(serverExp);
    }

    public WarningException(String message) {
        super(ServerExp.业务异常.getCode(), message);
        mapping(message);
    }

    public WarningException(GeneralException exception) {
        super(exception);
    }

    public WarningException(GeneralInternational international) {
        super(international.getJsl(), international.getDescription());
    }

    public WarningException(Integer code, String message) {
        super(code, message);
    }
}
