package com.jhscale.common.internatonal;

import com.jhscale.common.exception.GeneralException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: ExpInternationResponse
 * @projectName common
 * @description: TODO
 * @date 2020-12-100:16
 */
@ApiModel("异常国际化响应信息")
public class ExpInternational extends International {

    @ApiModelProperty(value = "异常错误码", name = "code", hidden = true)
    private String code;

    @ApiModelProperty(value = "异常服务标识", name = "app", hidden = true)
    private String app;

    @ApiModelProperty(value = "异常服务级别", name = "level", hidden = true)
    private String level;

    public ExpInternational() {
    }

    public ExpInternational(String jsl, String msg) {
        super(jsl, msg);
    }

    public ExpInternational(GeneralException exception) {
        this(exception.getCode(), exception.getMsg(), exception.getApplication(), exception.getExpLevel());
    }

    public ExpInternational(String jsl, String msg, String app, String level) {
        super(jsl, msg);
        int index = jsl.lastIndexOf("-");
        this.code = index == -1 ? jsl : jsl.substring(index + 1);
        this.app = app;
        this.level = level;
    }

    @Override
    public String toString() {
        return "ExpInternational{" +
                "code='" + code + '\'' +
                ", app='" + app + '\'' +
                ", level='" + level + '\'' +
                '}';
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getApp() {
        return app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }
}
