package com.jhscale.common.internatonal;

import com.jhscale.common.em.ExpParamType;
import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.RunGeneralException;
import com.jhscale.common.model.exp.ExpKVModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author lie_w
 * @title: ExpInternational
 * @projectName common
 * @description: TODO
 * @date 2020-12-0219:31
 */
@ApiModel("异常国际化对象")
public class ExpInternationalEntity extends ExpInternational {

    @ApiModelProperty(value = "异常类型", name = "type", hidden = true)
    private ExpParamType type;

    @ApiModelProperty(value = "异常对应值", name = "expVal", hidden = true)
    private ExpVal expVal;

    public ExpInternationalEntity() {
    }

    public ExpInternationalEntity(String code, String msg, String application, String level) {
        super(code, msg, application, level);
    }

    public ExpInternationalEntity(GeneralException exception) {
        this(exception.getCode(), exception.getMsg(), exception.getApplication(), exception.getExpLevel());
        this.type = exception.getParamType();
        this.expVal = new ExpVal(exception.getMsgs(), exception.getKvModels());
    }

    public ExpInternationalEntity(RunGeneralException exception) {
        this(exception.getCode(), exception.getMsg(), exception.getApplication(), exception.getExpLevel());
        this.type = exception.getParamType();
        this.expVal = new ExpVal(exception.getMsgs(), exception.getKvModels());
    }

    @Override
    public String toString() {
        return super.toString() +
                "ExpInternationalEntity{" +
                "type=" + type +
                ", expVal=" + expVal +
                '}';
    }

    public static class ExpVal {
        @ApiModelProperty(value = "String %s 替换异常信息值", name = "msgs", hidden = true)
        private List<String> msgs;

        @ApiModelProperty(value = "KV 异常替换信息值", name = "kvModels", hidden = true)
        private List<ExpKVModel> kvModels;

        public ExpVal() {
        }

        public ExpVal(List<String> msgs, List<ExpKVModel> kvModels) {
            this.msgs = msgs;
            this.kvModels = kvModels;
        }

        @Override
        public String toString() {
            return "ExpVal{" +
                    "msgs=" + msgs +
                    ", kvModels=" + kvModels +
                    '}';
        }

        public List<String> getMsgs() {
            return msgs;
        }

        public void setMsgs(List<String> msgs) {
            this.msgs = msgs;
        }

        public List<ExpKVModel> getKvModels() {
            return kvModels;
        }

        public void setKvModels(List<ExpKVModel> kvModels) {
            this.kvModels = kvModels;
        }
    }

    public ExpParamType getType() {
        return type;
    }

    public void setType(ExpParamType type) {
        this.type = type;
    }

    public ExpVal getExpVal() {
        return expVal;
    }

    public void setExpVal(ExpVal expVal) {
        this.expVal = expVal;
    }
}
