package com.jhscale.common.internatonal;

import com.jhscale.common.em.ServerExp;
import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: International
 * @projectName common
 * @description: TODO
 * @date 2020-12-0219:27
 */
@ApiModel("国际化信息")
public class International extends JSONModel {
    @ApiModelProperty(value = "语言标识", name = "jsl", hidden = true)
    private String jsl;

    @ApiModelProperty(value = "语言内容", name = "msg", hidden = true)
    private String msg;

    public International() {
    }

    public International(String jsl, String msg) {
        this.jsl = jsl;
        this.msg = msg;
    }

    public International(ServerExp serverExp) {
        this.jsl = serverExp.getCode();
        this.msg = serverExp.getMessage();
    }

    public String getJsl() {
        return jsl;
    }

    public void setJsl(String jsl) {
        this.jsl = jsl;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * @description: 国际化标识KEY
     **/
    public String internationalKey() {
        int index = jsl.lastIndexOf("-");
        return index == -1 ? this.jsl : this.jsl.substring(index + 1);
    }
}
