package com.jhscale.common.internatonal;

import com.jhscale.common.content.JHContents;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: InternationalAdapter
 * @projectName common
 * @description: TODO
 * @date 2020-12-0221:58
 */
public interface InternationalAdapter {

    /**
     * @description: 翻译
     **/
    String translation(String language, String key);

    /**
     * @description: 翻译 设置默认值
     **/
    default String translationDefualVal(String language, String key, String defaultVal) {
        String translation = this.translation(language, key);
        return StringUtils.isBlank(translation) ? (StringUtils.isNotBlank(defaultVal) ? defaultVal : key) : translation;
    }

    /**
     * @description: 翻译 返空默认值 Translation Lost
     **/
    default String translationDefualVal(String language, String key) {
        return this.translationDefualVal(language, key, JHContents.LANGUAGE_LOST);
    }

    /**
     * @description: 翻译 返空默认值 Key
     **/
    default String translationDefualKeyVal(String language, String key) {
        return this.translationDefualVal(language, key, key);
    }

    /**
     * @description: 翻译 系统语言 + 默认值
     **/
    default String translationDefaulLanguage(String key, String defaultVal) {
        return this.translationDefualVal(JHContents.SYS_DEFAUL_LANGUAGE, key, defaultVal);
    }

    /**
     * @description: 翻译 系统语言 + 返空默认值 Translation Lost
     **/
    default String translationDefaulLanguage(String key) {
        return this.translationDefualVal(JHContents.SYS_DEFAUL_LANGUAGE, key);
    }
}
