package com.jhscale.common.model.business;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: Currency
 * @projectName ysscale-base
 * @description: TODO
 * @date 2022/12/2022:37
 */
public class Currency extends JSONModel {

    @ApiModelProperty(value = "货币符号", name = "symbol")
    private String symbol = JHContents.DEFAULT_CURRENCY_SYMBOL;

    @ApiModelProperty(value = "货币小数点位数", name = "point")
    private int point = JHContents.DEFAULT_CURRENCY_POINT;

    public Currency() {
    }

    public Currency(String symbol, int point) {
        this.symbol = symbol;
        this.point = point;
    }

    public Currency(String moneyCurrency) {
        if (StringUtils.isNotBlank(moneyCurrency)) {
            String[] split = moneyCurrency.split(JHContents.DEFAULT_SPLIT);
            if (split != null && split.length == 2) {
                this.symbol = split[0];
                try {
                    this.point = Integer.parseInt(split[1]);
                } catch (NumberFormatException e) {
                    this.point = JHContents.DEFAULT_CURRENCY_POINT;
                }
            }
        }
    }

    public String getSymbol() {
        return symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public int getPoint() {
        return point;
    }

    public void setPoint(int point) {
        this.point = point;
    }
}
