package com.jhscale.common.model.business;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: Operator
 * @projectName ysscale-base
 * @description: TODO
 * @date 2022/8/2417:37
 */
@ApiModel("操作人")
public class Operator extends JSONModel {

    @ApiModelProperty(value = "操作人类型", name = "rule")
    private String rule;

    @ApiModelProperty(value = "操作人ID", name = "id")
    private Integer id;

    @ApiModelProperty(value = "操作人标识", name = "sign")
    private Long sign;

    @ApiModelProperty(value = "操作人名称", name = "name")
    private String name;

    public Operator() {
    }

    public Operator(String name) {
        this.name = name;
    }

    public Operator(Integer id, Long sign, String name) {
        this.id = id;
        this.sign = sign;
        this.name = name;
    }

    public Operator(String rule, Integer id, Long sign, String name) {
        this.rule = rule;
        this.id = id;
        this.sign = sign;
        this.name = name;
    }

    /**
     * @description: 操作人有效性检查
     * @date: 2025-06-18 14:15:37
     **/
    public boolean validate() {
        return Objects.nonNull(this.id) || Objects.nonNull(this.sign) || StringUtils.isNotBlank(this.name);
    }

    /**
     * @description: 操作人信息
     * @date: 2025-06-18 14:15:13
     **/
    public String operator() {
        return Objects.nonNull(sign) ? sign.toString() : (StringUtils.isNotBlank(name) ? name : (Objects.nonNull(id) ? id.toString() : JHContents.INVENT_CODE));
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Long getSign() {
        return sign;
    }

    public void setSign(Long sign) {
        this.sign = sign;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
