package com.jhscale.common.model.db;

import com.jhscale.common.model.http.JResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author lie_w
 * @title: Page
 * @projectName common
 * @description: TODO
 * @date 2020-11-0421:38
 */
@ApiModel("分页响应对象")
public class Page<T> extends JResponse {

    @ApiModelProperty(value = "总条数", name = "total", required = true)
    private long total;

    @ApiModelProperty(value = "数据内容", name = "rows", required = true)
    private List<T> rows;

    @ApiModelProperty(value = "当前页数", name = "nowPage", required = true)
    private int nowPage;

    @ApiModelProperty(value = "总页数", name = "pageNumber", required = true)
    private int pageNumber;

    @ApiModelProperty(value = "每页显示数", name = "pageSize", required = true)
    private int pageSize;

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getRows() {
        return rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public int getNowPage() {
        return nowPage;
    }

    public void setNowPage(int nowPage) {
        this.nowPage = nowPage;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
