package com.jhscale.common.model.db;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author wang lie
 * @ClassName: BasePageQuery
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2018/11/15 17:22
 * @Version: V1.0.0
 */
public class Query extends JSONModel {


    /**
     * @Description: 模糊查询
     */
    @ApiModelProperty(value = "模糊查询", name = "search")
    private String search;

    /**
     * @Description: 排序方式 规则 "字段1 ASC/DESC,字段2 ASC/DESC,..."
     */
    @ApiModelProperty(value = "排序方式 规则 '字段1 ASC/DESC,字段2 ASC/DESC,...'", name = "order")
    private String order;

    /**
     * 查询的源头 WEB or MOV
     */
    @ApiModelProperty(value = "查询表名时间", name = "tableTime")
    private String tableTime;

    /**
     * @description: 排序键值对，key 字段 value 排序类型
     **/
    public Map<String, String> orderMap() {
        if (StringUtils.isNotBlank(this.order)) {
            Map<String, String> orderMap = new HashMap<>();
            String[] split = this.order.split(",");
            for (String s : split) {
                String[] split_i = s.split(" ");
                orderMap.put(split_i[0], split_i[1]);
            }
            return orderMap;
        }
        return null;
    }

    public String getSearch() {
        return search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getTableTime() {
        return tableTime;
    }

    public void setTableTime(String tableTime) {
        this.tableTime = tableTime;
    }
}
