package com.jhscale.common.model.device;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * @author lie_w
 * @title: DeviceConstant
 * @projectName common
 * @description: TODO
 * @date 2021-02-2711:13
 */
public interface DConstant {

    /**
     * 秤种类
     */
    // 条码秤
    Integer BAR_KIND = 0;
    // POST秤
    Integer POS_KIND = 1;
    // 蓝牙吊秤
    Integer BT_CRANE_KIND = 2;

    /**
     * 日志类型
     */
    // 销售
    Integer SCALE = 0;
    // 退货
    Integer RETRUN = 1;
    // 未确认
    Integer UNCONFIRMED = 2;
    // 清除
    Integer CLEAR = 3;
    // 挂单
    Integer REGISTER = 4;
    // 自动模式
    Integer AUTO = 5;
    // 入库
    Integer STOCK_IN = 10;
    // 出库
    Integer STOCK_OUT = 11;
    // 盘库
    Integer INVENTORY = 12;
    // 订单
    Integer ORDER = 13;
    // 损耗
    Integer LOSS = 14;
    // 错误日志
    Integer ERROR_LOG = 255;

    /**
     * 修正标志
     */
    // 修正
    String DATE_REVISE = "1";
    // 未修正
    String DATE_UNREVISE = "0";

    /**
     * 未知支付标识
     */
    // 未知支付
    String UNKNOW_PAY = "1";
    //正常支付
    String KNOW_PAY = "0";

    /**
     * 错误码
     */
    // 收银秤未知支付错误码
    // 195 支付错误
    String PAY_ERR_HEX_CODE = "000000C3";
    String PAY_ERR_CODE = "195";

    /**
     * 分隔符
     */
    String ARRAY_SPLIT = "φ";
    String CLASS_PREFIX = "ωω";
    String FIELD_SPLIT = "θ";
    String INNER_FIELD_SPLIT = "σ";
    String LIST_SPLIT_START = "{";
    String LIST_SPLIT_END = "}";
    String LIST_SPLIT = "η";
    String MAP_KEY = "δ";
    String SPACE = " ";
    String FIELD_MODEL_SPLIT = "μ";

    /**
     * 部门分组默认起始编号
     */
    Integer DEFAULT_CLASS = 10;
    String DEFAULT_CLASS_STR = "10";
    Integer DEFAULT_DEPT = 10;
    String DEFAULT_DEPT_STR = "10";

    /**
     * 其他常量
     */
    Integer ZERO = 0;
    Integer BAR_SCALE_AUTH_LENGTH = 32;
    Integer SAVE_WEIGHT_ENABLE = 1;
    Integer SAVE_WEIGHT_DISABLE = 0;
    Integer PLU_State_NORMAL = 2;
    String DEFAULT_V0 = "0";
    Integer DEFAULT_I0 = 0;
    String DEFAULT_SHORT_NAME = "SK1";

    /**
     * @description: 数据类型
     **/
    int INT = 1;// int 类型
    int DOUBLE = 10;// double 类型
    int LNG = 2;// long 类型
    int LNT = 3;// long 时间类型
    int TME = 4;// 时间 类型
    int TME_M1 = 41;// 时间 类型 230510
    int BDL = 5;// BigDecimal 类型
    int FML = 6; // FieldModel 类型
    int FML_M1 = 60; // FieldModel 类型
    int TXT = 7;// 文本 类型
    int TXT_M1 = 70;// 字符直接添加不参与替换
    int LST = 8;// List 类型
    int LST1_M1 = 80;// List1 日志使用
    int MAP = 9;// MAP 类型
    int M0 = 100;// 自定义0号方法
    int M1 = 101;// 自定义1号方法
    int M2 = 102;// 自定义2号方法
    int M3 = 103;// 自定义3号方法
    int M4 = 104;// 自定义4号方法
    int M5 = 105;// 自定义5号方法
    int M6 = 106;// 自定义6号方法
    int M7 = 107;// 自定义7号方法

    String DP_SPLIT1 = ":";
    String DP_SPLIT2 = "|";
    String DP_SPLIT4 = "=";
    String DP_SPLIT2_1 = "\\|";
    String DP_P = "P";
    String DP_M = "M";
    String DP_A = "A";

    Charset DEFAULT_CHARSET = Charset.forName("GBK");
    Charset UTF_8 = StandardCharsets.UTF_8;
    String TXT_END = "00";

    // 下发 变更
    // DWL MARK
    // MARK n val
    // END MARK
    String PUBLIC_MDF = "DWL";

    // 删除 CLR MARK n
    // CLR MARK n
    // CLR END
    // n = 0 代表清除所有相关的数据
    // n > 0 （非REP命令字）代表清除指定编号的数据（n号PLU）
    // n > 0 （REP命令字）在数据库中，将所有FID<=n的日志标记为已删除（注意，只是标记为删除，其实并未删除）
    String PUBLIC_CLR = "CLR";

    // 回收 UPL MARK n
    // UPL MARK n
    // UPL END
    // n = 0 （非REP命令字）代表上传所有相关的数据
    // n > 0 （非REP命令字）代表上传指定编号的数据（n号PLU）
    // n = 0 （REP命令字）在数据库中，将所有标记为“未上传”的日志上传，并标记为“已上传”
    // n > 0 （REP命令字）在数据库中，将所有FID>=n且未标记“已删除”的日志上传，并标记为“已上传”
    // n < 0 （REP命令字）在数据库中，将所有FID>="-n"的日志上传(无视已删除标记)，并标记为“已上传”
    String PUBLIC_UPL = "UPL";

    // 通讯事件
    String PUBLIC_ASK = "ASK";

    // 指令结束
    String PUBLIC_END = "END";

    String PUBLIC_FIELD_SPLIT = "\t";
    String PUBLIC_FIELD_SPLIT_1 = "#";
    String PUBLIC_FIELD_SPLIT_2 = "~";
    String PUBLIC_FIELD_SPLIT_3 = ",";
    String PUBLIC_FIELD_SPLIT_4 = "|";
    String PUBLIC_FIELD_SPLIT_4_1 = "\\|";

    String PUBLIC_LINE_SPLIT = "\r\n";
    String PUBLIC_LINE_SPLIT_1 = "\n";
    String PUBLIC_SET_FIELD_SPLIT = "&";
    String PUBLIC_SET_FIELD_SPLIT_1 = "!";
    String PUBLIC_SET_FIELD_SPLIT_2 = "%";
    String PUBLIC_KV_SET_FIELD_SPLIT = "@";

    String DEFAULT_IGNORE_PUBLIC_FIELD_CODE_LAST = "code,last";

    String TMS = "TMS";// 数据参数
    String TMT = "TMT";// 文本参数

    String ALL = "ALL";// 所有数据信息
    String CLS = "CLS";// 分组
    String PLU = "PLU";// 商品信息
    String BAR = "BAR";// 条码参数
    String LTB = "LTB";// 小秤标签格式1
    String LTS = "LTS";// 小秤标签格式2
    String LTE = "LTE";// 小秤标签格式3
    String LAT = "LAT";// POS标签格式
    String SAJ = "SAJ";// 营业员
    String SAL = "SAL";// 营业员
    String SCP = "SCP";// 快捷键
    String SCG = "SCG";// POS快捷页
    String SGF = "SGF";// POS快捷页模板
    String AIF = "AIF";// AI特征信息
    String BMP = "BMP";// 位图
    String FNT = "FNT";// 字库
    String INF = "INF";// 信息获取
    String INF_INA = "INA";// 信息获取 INA
    String INF_INM = "INM";// 信息获取 INM
    String INF_INF = "INF";// 信息获取 INF
    String INF_INI = "INI";// 信息获取 INI AI信息
    String MAC = "MAC"; // MAC≈INF
    String TIM = "TIM";

    String REP = "REP";// 日志
    String RES = "RES";// 日志 交易开始
    String REE = "REE";// 日志 交易结束

    String SPP = "SPP";// 营养表

    String FILE_Charset = "GBK";

    String DATA_FILE_SUFFIX = "TMS";
    String DATA_FILE_TYPE = "." + DATA_FILE_SUFFIX;

    String VERSION_FORMAT = "%s %s %s";

    String BD_VALID_FILED = "0000000F";
    String DT_VALID_FILED = "FFFFFFFF";

    /**
     * @description: WebSocket 指令
     **/
    String CLOUD_PAY_Pretreatment_S = "1001";
    String CLOUD_PAY_Pretreatment_E = "1101";
    String CLOUD_PAY_SCAN_PAYMENT = "1201";
    String CLOUD_PAY_QUERY = "1301";
    String CLOUD_REFUND = "1401";
    String CLOUD_REFUND_QUERY = "1501";
    String CLOUD_END_PAYMENT = "1601";

    String JKY_LOGIN = "2001";
    String JKY_LOGIN_QUERY = "2101";
    String JKY_LOGOUT = "2201";
    String JKY_USER_LIKE_QUERY = "2301";
    String JKY_CARD_ISSUED = "2401";
    String JKY_CARD_BIND_CHECK = "2501";
    String JKY_CARD_BIND = "2601";
    String JKY_SETTING = "2701";
    String JKY_RECHARGE_SET_MEAL = "2801";
    String JKY_INTEGRAL_SET_MEAL = "2901";
    String JKY_PAY = "2A01";
    String JKY_PAY_QUERY = "2B01";
    String JKY_RECHARGE = "2C01";
    String JKY_RECHARGE_QUERY = "2D01";
    String JKY_REFUND = "2E01";
    String JKY_REFUND_QUERY = "2F01";
    String JKY_INTEGRAL = "3001";
    String JKY_INTEGRAL_QUERY = "3101";
    String JKY_Cancel = "3201";
    String JKY_Cancel_QUERY = "3301";
}
