package com.jhscale.common.model.device;

import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.annotation.ServerField;
import com.jhscale.common.model.inter.DataJSONModel;

import static com.jhscale.common.model.device.DConstant.INT;

/**
 * @author lie_w
 * @title: DData
 * @projectName common
 * @description: 数据更新原则
 * code == 0 no != 0 新增
 * code != 0 no == 0 删除
 * 其余更新
 * @date 2022/10/1010:33
 */
public class DData<T extends DData> implements DataJSONModel<T> {

    // @ApiModelProperty(value = "编号", name = "no")
    @ServerField(index = 1, length = 8, type = INT, must = true)
    @PublicField(index = 1, type = INT)
    private Integer no;

//    @ApiModelProperty(value = "系统业务编号", name = "code")
//    @PublicField(index = 100, type = LNG)
//    private Long code;
//
//    @ApiModelProperty(value = "最后更新时间", name = "last")
//    @PublicField(index = 101, type = LNG)
//    private Long last;

    public Integer getNo() {
        return this.no;
    }

    /**
     * @description: 编号
     **/
    @Override
    public Integer no() {
        return this.no;
    }

    /**
     * @param no
     * @description: 添加编号
     */
    @Override
    public void sno(Integer no) {
        this.no = no;
    }

    public T setNo(Integer no) {
        this.no = no;
        return (T) this;
    }

//    public Long getCode() {
//        return code;
//    }
//
//    public T setCode(Long code) {
//        this.code = code;
//        return (T) this;
//    }
//
//    public Long getLast() {
//        return last;
//    }
//
//    public T setLast(Long last) {
//        this.last = last;
//        return (T) this;
//    }
}
