package com.jhscale.common.model.device;

import com.google.gson.Gson;
import com.jhscale.common.model.device.plu.inner.DCategory;
import com.jhscale.common.model.device.plu.inner.DDept;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.utils.GJSONUtils;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author lie_w
 * @title: DeviceLog
 * @projectName common
 * @description: 设备日志信息
 * @date 2021-02-269:02
 */
@Deprecated
public class DLog extends JSONModel {

    @ApiModelProperty(value = "日志种类", name = "kind", example = "0：条码秤；1：POS秤；2：蓝牙吊秤；3：VPS PC Post")
    private Integer kind;

    @ApiModelProperty(value = "HEX Fid 唯一标识", name = "hfid")
    private String hfid;

    @ApiModelProperty(value = "INT Fid 唯一标识", name = "ifid")
    private Long ifid;

    @ApiModelProperty(value = "交易时间 毫秒数", name = "tradeTime")
    private Long tradeTime;

    @ApiModelProperty(value = "修正标志", name = "reviseFlag")
    private String reviseFlag = DConstant.DATE_UNREVISE;

    @ApiModelProperty(value = "修正交易时间", name = "reviseTime")
    private Long reviseTime;

    @ApiModelProperty(value = "未知支付标识", name = "unknowPay", example = "1-未知支付 0-正常支付")
    private String unknowPay = DConstant.KNOW_PAY;

    @ApiModelProperty(value = "SID", name = "sid")
    private String sid;

    @ApiModelProperty(value = "交易额", name = "tradeVal")
    private BigDecimal tradeVal;

    @ApiModelProperty(value = "日志类型", name = "type", example = "0:销售;1:退货;2:未确认;3:清除; 4:挂单;5:自动模式;6~9:预留; 10:入库;11:出库;12:盘库;13:订单;14:损耗;255:错误日志")
    private String type;

    @ApiModelProperty(value = "累计数笔数", name = "count")
    private Integer count;

    @ApiModelProperty(value = "营业员编号", name = "saleman")
    private Long saleman;

    @ApiModelProperty(value = "折舍金额", name = "roudingDiscount")
    private BigDecimal roudingDiscount;

    @ApiModelProperty(value = "税额", name = "tax")
    private BigDecimal tax;

    @ApiModelProperty(value = "成本", name = "cost")
    private BigDecimal cost;

    @ApiModelProperty(value = "现金", name = "cash")
    private BigDecimal cash;

    @ApiModelProperty(value = "卡付", name = "cardPay")
    private BigDecimal cardPay;

    @ApiModelProperty(value = "其他支付1", name = "otherPay1")
    private BigDecimal otherPay1;

    @ApiModelProperty(value = "其他支付2", name = "otherPay2")
    private BigDecimal otherPay2;

    @ApiModelProperty(value = "其他支付3", name = "otherPay3")
    private BigDecimal otherPay3;

    @ApiModelProperty(value = "服务费", name = "serviceCharge")
    private BigDecimal serviceCharge;

    @ApiModelProperty(value = "CoFID", name = "coFid")
    private String coFid;

    @ApiModelProperty(value = "支付宝", name = "aliPay")
    private BigDecimal aliPay;

    @ApiModelProperty(value = "微信支付", name = "weixinPay")
    private BigDecimal weixinPay;

    @ApiModelProperty(value = "特殊支付2(预留) 吉卡云消费", name = "specialPay2")
    private BigDecimal specialPay2;

    @ApiModelProperty(value = "特殊支付3(预留) 吉卡云赠送金额消费", name = "specialPay3")
    private BigDecimal specialPay3;

    @ApiModelProperty(value = "特殊支付4(预留)", name = "specialPay4")
    private BigDecimal specialPay4;

    @ApiModelProperty(value = "特殊支付5(预留)", name = "specialPay5")
    private BigDecimal specialPay5;

    @ApiModelProperty(value = "特殊支付6(预留)", name = "specialPay6")
    private BigDecimal specialPay6;

    @ApiModelProperty(value = "特殊支付7(预留)", name = "specialPay7")
    private BigDecimal specialPay7;

    @ApiModelProperty(value = "错误代码", name = "errCode")
    private String errCode;

    @ApiModelProperty(value = "错误文本1", name = "errMsg1")
    private String errMsg1;

    @ApiModelProperty(value = "错误文本2", name = "errMsg2")
    private String errMsg2;

    @ApiModelProperty(value = "错误文本3", name = "errMsg3")
    private String errMsg3;

    @ApiModelProperty(value = "错误文本4", name = "errMsg4")
    private String errMsg4;

    @ApiModelProperty(value = "吉卡云消费金额", name = "jkyPay")
    private BigDecimal jkyPay;

    @ApiModelProperty(value = "吉卡云赠送支付", name = "jkyGiftPay")
    private BigDecimal jkyGiftPay;

    @ApiModelProperty(value = "充值金额", name = "jkyRecharge")
    private BigDecimal jkyRecharge;

    @ApiModelProperty(value = "充值赠送", name = "jkyRechargeGift")
    private BigDecimal jkyRechargeGift;

    private List<LogGood> logGoods;

    /**
     * @description: 拼装日志字符串
     **/
    public String assemble() {
        Field[] fields = this.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Map<String, String> map = new HashMap<>();
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    Object obj = field.get(this);

                    if (obj != null) {
                        if (obj instanceof List) {
                            List list = (List) obj;
                            StringBuffer listBuffer = new StringBuffer();
                            for (Object o : list) {
                                Field[] innerFields = o.getClass().getDeclaredFields();
                                if (innerFields != null && innerFields.length > 0) {
                                    Map<String, String> innerMap = new HashMap<>();
                                    for (Field innnerField : innerFields) {
                                        innnerField.setAccessible(true);
                                        Object innerObj = innnerField.get(o);
                                        if (Objects.nonNull(innerObj)) {
                                            if (innnerField.getType().equals(String.class)) {
                                                innerMap.put(innnerField.getName(), innerObj.toString());
                                            } else {
//                                                innnerMap.put(innnerField.getName(), JSONObject.toJSONString(innerObj));
                                                innerMap.put(innnerField.getName(), GJSONUtils.objectToJSON(innerObj));
                                            }
                                        } else {
                                            innerMap.put(innnerField.getName(), DConstant.SPACE);
                                        }
                                    }

                                    Set<String> keySet = innerMap.keySet();
                                    String[] innerKeys = keySet.toArray(new String[keySet.size()]);
                                    Arrays.sort(innerKeys, String.CASE_INSENSITIVE_ORDER);

                                    StringBuffer innerBuffer = new StringBuffer();
                                    for (String innerKey : innerKeys) {
                                        innerBuffer.append(innerMap.get(innerKey)).append(DConstant.INNER_FIELD_SPLIT);
                                    }

                                    listBuffer.append(DConstant.LIST_SPLIT_START).append(innerBuffer.substring(0, innerBuffer.length() - 1)).append(DConstant.LIST_SPLIT_END).append(DConstant.LIST_SPLIT);
                                }
                            }
                            map.put(field.getName(), listBuffer.substring(0, listBuffer.length() - 1));
                        } else {
                            map.put(field.getName(), obj.toString());
                        }
                    } else {
                        map.put(field.getName(), DConstant.SPACE);
                    }
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }

            Set<String> keySet = map.keySet();
            String[] keys = keySet.toArray(new String[keySet.size()]);
            Arrays.sort(keys, String.CASE_INSENSITIVE_ORDER);

            StringBuffer buffer = new StringBuffer();
            for (String key : keys) {
                buffer.append(map.get(key)).append(DConstant.FIELD_SPLIT);
            }
            return buffer.substring(0, buffer.length() - 1);
        }
        return null;
    }

    /**
     * @description: 拼装压缩
     **/
    public String assembleZip() {
        return Base64Utils.gzipString(this.assemble());
    }

    /**
     * @description: 解析
     **/
    public static DLog unzipParse(String logData) {
        return parse(Base64Utils.ungzipString(logData));
    }

    /**
     * @description: 解析
     **/
    public static DLog parse(String logData) {
        if (StringUtils.isNotBlank(logData)) {
            String[] fieldSplits = logData.split(DConstant.FIELD_SPLIT);
            if (fieldSplits != null && fieldSplits.length > 0) {
                DLog log = new DLog();
                Class<? extends DLog> clazz = log.getClass();
                Class<?> innerClazz = null;
                List<String> keys = new ArrayList<>();
                List<String> innerKeys = new ArrayList<>();

                Field[] fields = clazz.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    for (Field field : fields) {
                        if (field.getType().equals(List.class)) {
                            Type genericType = field.getGenericType();
                            if (genericType instanceof ParameterizedType)
                                innerClazz = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments()[0];

                            Field[] innnerFields = innerClazz.getDeclaredFields();
                            if (innnerFields != null && innnerFields.length > 0) {
                                for (Field innnerField : innnerFields) {
                                    innerKeys.add(innnerField.getName());
                                }
                            }
                        }
                        keys.add(field.getName());
                    }
                }

                String[] keyArray = keys.toArray(new String[keys.size()]);
                Arrays.sort(keyArray, String.CASE_INSENSITIVE_ORDER);
                String[] innerKeyArray = innerKeys.toArray(new String[innerKeys.size()]);
                Arrays.sort(innerKeyArray, String.CASE_INSENSITIVE_ORDER);

                for (int i = 0; i < keyArray.length; i++) {
                    String fieldVal = fieldSplits[i];
                    if (StringUtils.isNotBlank(fieldVal)) {
                        Object val = fieldVal;
                        if (fieldVal.startsWith(DConstant.LIST_SPLIT_START) && fieldVal.endsWith(DConstant.LIST_SPLIT_END)) {
                            String[] innerFields = fieldVal.split(DConstant.LIST_SPLIT);
                            List<String> innerFieldList = new ArrayList<>(innerFields.length);
                            for (String innerField : innerFields) {
                                innerFieldList.add(innerField.substring(1, innerField.length() - 1));
                            }

                            val = new ArrayList();
                            for (String innerField : innerFieldList) {
                                try {
                                    Object innerObj = innerClazz.newInstance();

                                    String[] innerFieldSplits = innerField.split(DConstant.INNER_FIELD_SPLIT);
                                    for (int j = 0; j < innerKeyArray.length; j++) {
                                        String innerFieldVal = innerFieldSplits[j];
                                        if (StringUtils.isNotBlank(innerFieldVal)) {
                                            Field inField = innerClazz.getDeclaredField(innerKeyArray[j]);
                                            inField.setAccessible(true);
                                            addField(innerObj, inField, innerFieldVal);
                                        }
                                    }
                                    ((List) val).add(innerObj);
                                } catch (InstantiationException | IllegalAccessException | NoSuchFieldException e) {
                                    e.printStackTrace();
                                }
                            }
                        }

                        try {
                            Field field = clazz.getDeclaredField(keyArray[i]);
                            field.setAccessible(true);
                            addField(log, field, val);
                        } catch (NoSuchFieldException | IllegalAccessException e) {
                            e.printStackTrace();
                        }

                    }
                }
                return log;
            }
        }
        return null;
    }

    private static void addField(Object bean, Field field, Object val) throws IllegalAccessException {
        if (field.getType().equals(Integer.class)) {
            field.set(bean, Integer.parseInt(val.toString()));
        } else if (field.getType().equals(Long.class)) {
            field.set(bean, Long.parseLong(val.toString()));
        } else if (field.getType().equals(BigDecimal.class) && StringUtils.isNotBlank(val.toString())) {
            field.set(bean, new BigDecimal(val.toString()));
        } else if (field.getType().equals(DDept.class)) {
//            field.set(bean, JSONObject.parseObject(val.toString(), DDept.class));
            field.set(bean, new Gson().fromJson(val.toString(), DDept.class));
        } else if (field.getType().equals(DCategory.class)) {
//            field.set(bean, JSONObject.parseObject(val.toString(), DCategory.class));
            field.set(bean, new Gson().fromJson(val.toString(), DCategory.class));
        } else {
            field.set(bean, val);
        }
    }

    /**
     * @description: 日志商品
     **/
    public static class LogGood {

        @ApiModelProperty(value = "PLU编号", name = "pluNo")
        private Long pluNo;

        @ApiModelProperty(value = "系统唯一编号", name = "pluCode")
        private Long pluCode;

        @ApiModelProperty(value = "商品名称", name = "pluName")
        private String pluName;

        @ApiModelProperty(value = "单位 库存单位类型", name = "unit")
        private String unit;

        @ApiModelProperty(value = "重量", name = "weight")
        private BigDecimal weight;

        @ApiModelProperty(value = "数量", name = "amount")
        private BigDecimal amount;

        @ApiModelProperty(value = "单价", name = "price")
        private BigDecimal price;

        @ApiModelProperty(value = "单计", name = "itemTotal")
        private BigDecimal itemTotal;

        @ApiModelProperty(value = "类别 组别", name = "category")
        private DCategory category;

        @ApiModelProperty(value = "部门", name = "dept")
        private DDept dept;

        @ApiModelProperty(value = "税额", name = "tax")
        private BigDecimal tax;

        @ApiModelProperty(value = "成本", name = "cost")
        private BigDecimal cost;

        @ApiModelProperty(value = "文本1", name = "text1")
        private String text1;

        @ApiModelProperty(value = "文本2", name = "text2")
        private String text2;

        @ApiModelProperty(value = "文本3", name = "text3")
        private String text3;

        @ApiModelProperty(value = "文本4", name = "text4")
        private String text4;

        public Long getPluNo() {
            return pluNo;
        }

        public void setPluNo(Long pluNo) {
            this.pluNo = pluNo;
        }

        public Long getPluCode() {
            return pluCode;
        }

        public void setPluCode(Long pluCode) {
            this.pluCode = pluCode;
        }

        public String getPluName() {
            return pluName;
        }

        public void setPluName(String pluName) {
            this.pluName = pluName;
        }

        public String getUnit() {
            return unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public BigDecimal getWeight() {
            return weight;
        }

        public void setWeight(BigDecimal weight) {
            this.weight = weight;
        }

        public BigDecimal getAmount() {
            return amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getPrice() {
            return price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public BigDecimal getItemTotal() {
            return itemTotal;
        }

        public void setItemTotal(BigDecimal itemTotal) {
            this.itemTotal = itemTotal;
        }

        public DCategory getCategory() {
            return category;
        }

        public void setCategory(DCategory category) {
            this.category = category;
        }

        public DDept getDept() {
            return dept;
        }

        public void setDept(DDept dept) {
            this.dept = dept;
        }

        public BigDecimal getTax() {
            return tax;
        }

        public void setTax(BigDecimal tax) {
            this.tax = tax;
        }

        public BigDecimal getCost() {
            return cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public String getText1() {
            return text1;
        }

        public void setText1(String text1) {
            this.text1 = text1;
        }

        public String getText2() {
            return text2;
        }

        public void setText2(String text2) {
            this.text2 = text2;
        }

        public String getText3() {
            return text3;
        }

        public void setText3(String text3) {
            this.text3 = text3;
        }

        public String getText4() {
            return text4;
        }

        public void setText4(String text4) {
            this.text4 = text4;
        }
    }

    public Integer getKind() {
        return kind;
    }

    public void setKind(Integer kind) {
        this.kind = kind;
    }

    public String getHfid() {
        return hfid;
    }

    public void setHfid(String hfid) {
        this.hfid = hfid;
    }

    public Long getIfid() {
        return ifid;
    }

    public void setIfid(Long ifid) {
        this.ifid = ifid;
    }

    public Long getTradeTime() {
        return tradeTime;
    }

    public Date getTradeDate() {
        return new Date(this.tradeTime);
    }

    public void setTradeTime(Long tradeTime) {
        this.tradeTime = tradeTime;
    }

    public String getReviseFlag() {
        return reviseFlag;
    }

    public void setReviseFlag(String reviseFlag) {
        this.reviseFlag = reviseFlag;
    }

    public Long getReviseTime() {
        return reviseTime;
    }

    public Date getReviseDate() {
        return new Date(Objects.isNull(this.getReviseTime()) ? this.getTradeTime() : this.getReviseTime());
    }

    public void setReviseTime(Long reviseTime) {
        this.reviseTime = reviseTime;
    }

    public String getUnknowPay() {
        return unknowPay;
    }

    public void setUnknowPay(String unknowPay) {
        this.unknowPay = unknowPay;
    }

    public String getSid() {
        return sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public BigDecimal getTradeVal() {
        return tradeVal;
    }

    public void setTradeVal(BigDecimal tradeVal) {
        this.tradeVal = tradeVal;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Long getSaleman() {
        return saleman;
    }

    public void setSaleman(Long saleman) {
        this.saleman = saleman;
    }

    public BigDecimal getRoudingDiscount() {
        return roudingDiscount;
    }

    public void setRoudingDiscount(BigDecimal roudingDiscount) {
        this.roudingDiscount = roudingDiscount;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getCost() {
        return cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public void setCash(BigDecimal cash) {
        this.cash = cash;
    }

    public BigDecimal getCardPay() {
        return cardPay;
    }

    public void setCardPay(BigDecimal cardPay) {
        this.cardPay = cardPay;
    }

    public BigDecimal getOtherPay1() {
        return otherPay1;
    }

    public void setOtherPay1(BigDecimal otherPay1) {
        this.otherPay1 = otherPay1;
    }

    public BigDecimal getOtherPay2() {
        return otherPay2;
    }

    public void setOtherPay2(BigDecimal otherPay2) {
        this.otherPay2 = otherPay2;
    }

    public BigDecimal getOtherPay3() {
        return otherPay3;
    }

    public void setOtherPay3(BigDecimal otherPay3) {
        this.otherPay3 = otherPay3;
    }

    public BigDecimal getServiceCharge() {
        return serviceCharge;
    }

    public void setServiceCharge(BigDecimal serviceCharge) {
        this.serviceCharge = serviceCharge;
    }

    public String getCoFid() {
        return coFid;
    }

    public void setCoFid(String coFid) {
        this.coFid = coFid;
    }

    public BigDecimal getAliPay() {
        return aliPay;
    }

    public void setAliPay(BigDecimal aliPay) {
        this.aliPay = aliPay;
    }

    public BigDecimal getWeixinPay() {
        return weixinPay;
    }

    public void setWeixinPay(BigDecimal weixinPay) {
        this.weixinPay = weixinPay;
    }

    public BigDecimal getSpecialPay2() {
        return specialPay2;
    }

    public void setSpecialPay2(BigDecimal specialPay2) {
        this.specialPay2 = specialPay2;
    }

    public BigDecimal getSpecialPay3() {
        return specialPay3;
    }

    public void setSpecialPay3(BigDecimal specialPay3) {
        this.specialPay3 = specialPay3;
    }

    public BigDecimal getSpecialPay4() {
        return specialPay4;
    }

    public void setSpecialPay4(BigDecimal specialPay4) {
        this.specialPay4 = specialPay4;
    }

    public BigDecimal getSpecialPay5() {
        return specialPay5;
    }

    public void setSpecialPay5(BigDecimal specialPay5) {
        this.specialPay5 = specialPay5;
    }

    public BigDecimal getSpecialPay6() {
        return specialPay6;
    }

    public void setSpecialPay6(BigDecimal specialPay6) {
        this.specialPay6 = specialPay6;
    }

    public BigDecimal getSpecialPay7() {
        return specialPay7;
    }

    public void setSpecialPay7(BigDecimal specialPay7) {
        this.specialPay7 = specialPay7;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg1() {
        return errMsg1;
    }

    public void setErrMsg1(String errMsg1) {
        this.errMsg1 = errMsg1;
    }

    public String getErrMsg2() {
        return errMsg2;
    }

    public void setErrMsg2(String errMsg2) {
        this.errMsg2 = errMsg2;
    }

    public String getErrMsg3() {
        return errMsg3;
    }

    public void setErrMsg3(String errMsg3) {
        this.errMsg3 = errMsg3;
    }

    public String getErrMsg4() {
        return errMsg4;
    }

    public void setErrMsg4(String errMsg4) {
        this.errMsg4 = errMsg4;
    }

    public BigDecimal getJkyPay() {
        return jkyPay;
    }

    public void setJkyPay(BigDecimal jkyPay) {
        this.jkyPay = jkyPay;
    }

    public BigDecimal getJkyGiftPay() {
        return jkyGiftPay;
    }

    public void setJkyGiftPay(BigDecimal jkyGiftPay) {
        this.jkyGiftPay = jkyGiftPay;
    }

    public BigDecimal getJkyRecharge() {
        return jkyRecharge;
    }

    public void setJkyRecharge(BigDecimal jkyRecharge) {
        this.jkyRecharge = jkyRecharge;
    }

    public BigDecimal getJkyRechargeGift() {
        return jkyRechargeGift;
    }

    public void setJkyRechargeGift(BigDecimal jkyRechargeGift) {
        this.jkyRechargeGift = jkyRechargeGift;
    }

    public List<LogGood> getLogGoods() {
        return logGoods;
    }

    public void setLogGoods(List<LogGood> logGoods) {
        this.logGoods = logGoods;
    }
}
