package com.jhscale.common.model.device;


import com.jhscale.common.model.simple.FieldModel;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.ysscale.UnitEnum;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.*;

import static com.jhscale.common.utils.DPLUUtils.getResultBigDecimal;
import static com.jhscale.common.utils.DPLUUtils.getResultInteger;

/**
 * @author lie_w
 * @title: DPL
 * @projectName common
 * @description: 设备PLU信息
 * @date 2022/7/1916:11
 */
@Deprecated
public class DPLU extends JSONModel {

    @ApiModelProperty(value = "PLU编号", name = "pluNo")
    private Long pluNo;
    @ApiModelProperty(value = "PLU系统唯一编号", name = "pluCode")
    private Long pluCode;
    @ApiModelProperty(value = "商品名称", name = "pluName")
    private String pluName;
    @ApiModelProperty(value = "商品上架状态", name = "pluState", example = "1-下架 2-上架，3- 停售，4 - 缺货")
    private String pluState;
    @ApiModelProperty(value = "PLU序号", name = "sortOrder")
    private Integer sortOrder;
    @ApiModelProperty(value = "简写", name = "simple")
    private String simple;
    @ApiModelProperty(value = "库存单位", name = "unit")
    private Unit unit;
    @ApiModelProperty(value = "规格", name = "specification")
    private DSpecification specification;
    @ApiModelProperty(value = "图片", name = "pictures")
    private String pictures;
    @ApiModelProperty(value = "单价", name = "price")
    private BigDecimal price;

    @ApiModelProperty(value = "货号", name = "number")
    private Integer number;
    @ApiModelProperty(value = "索引条码", name = "indexBar")
    private String indexBar;
    @ApiModelProperty(value = "使用期信息", name = "usedate")
    private DUsedate usedate;
    @ApiModelProperty(value = "成本", name = "costTrade")
    private BigDecimal costTrade;
    @ApiModelProperty(value = "皮重", name = "trae")
    private BigDecimal trae;
    @ApiModelProperty(value = "主要类别", name = "category")
    private DCategory category;
    @ApiModelProperty(value = "次要类别编号", name = "secondCategoryIds")
    private String secondCategoryIds;
    @ApiModelProperty(value = "次要类别", name = "sencondCategorys")
    private List<DCategory> sencondCategorys;
    @ApiModelProperty(value = "打印格式1", name = "printInfo1")
    private DPrintInfo printInfo1;
    @ApiModelProperty(value = "打印格式2", name = "printInfo2")
    private DPrintInfo printInfo2;
    @ApiModelProperty(value = "文本内容 条码秤最大长度8 收银秤另说", name = "texts")
    private List<String> texts;
    @ApiModelProperty(value = "税率", name = "taxrate")
    private BigDecimal taxrate;
    @ApiModelProperty(value = "位图信息", name = "bitmap")
    private DBitmap bitmap;
    @ApiModelProperty(value = "销售日期", name = "saledate")
    private DSaledate saledate;
    @ApiModelProperty(value = "销售时间", name = "saletime")
    private DSaletime saletime;
    @ApiModelProperty(value = "包装日期", name = "packdate")
    private DPackdate packdate;
    @ApiModelProperty(value = "包装时间", name = "packtime")
    private DPacktime packtime;
    @ApiModelProperty(value = "手动折扣", name = "手动折扣")
    private String manualDiscount;
    @ApiModelProperty(value = "自动折扣1", name = "autoDiscount1")
    private String autoDiscount1;
    @ApiModelProperty(value = "自动折扣2", name = "autoDiscount2")
    private String autoDiscount2;
    @ApiModelProperty(value = "自动折扣3", name = "autoDiscount3")
    private String autoDiscount3;
    @ApiModelProperty(value = "自动折扣4", name = "autoDiscount4")
    private String autoDiscount4;

    public DPLU() {
    }

    public DPLU(String data, boolean base64) {
        Map<String, Field> fieldMap = this.allAndroidField();
        List<String> keys = this.sortMapKey(fieldMap);
        if (keys != null && !keys.isEmpty() && StringUtils.isNotBlank(data)) {
            if (base64) {
                data = Base64Utils.ungzipString(data);
            }
            String[] dataSplits = data.split(DConstant.FIELD_SPLIT);
            if (dataSplits != null && dataSplits.length > 0) {
                for (int i = 0; i < keys.size(); i++) {
                    String dataSplit = dataSplits[i];
                    if (StringUtils.isNotBlank(dataSplit)) {
                        Field field = fieldMap.get(keys.get(i));
                        field.setAccessible(true);

                        try {
                            Object obj = null;
                            if (field.getType().equals(BigDecimal.class)) {
                                obj = new BigDecimal(dataSplit);
                            } else if (field.getType().equals(Long.class)) {
                                obj = Long.parseLong(dataSplit);
                            } else if (field.getType().equals(Integer.class)) {
                                obj = Integer.parseInt(dataSplit);
                            } else if (field.getType().equals(String.class)) {
                                obj = dataSplit;
                            } else if (field.getType().equals(List.class)) {
                                dataSplit = dataSplit.substring(1, dataSplit.length() - 1);
                                List<String> dataList = Arrays.asList(dataSplit.split(DConstant.LIST_SPLIT));
                                Type genericType = field.getGenericType();
                                Class innerClazz = null;
                                if (genericType instanceof ParameterizedType) {
                                    innerClazz = (Class<?>) ((ParameterizedType) genericType).getActualTypeArguments
                                            ()[0];
                                }

                                if (innerClazz.equals(String.class)) {
                                    obj = dataList;
                                } else {
                                    List list = new ArrayList();
                                    for (String innerData : dataList) {
                                        Object innerObj = innerClazz.newInstance();
                                        if (innerObj instanceof FieldModel) {
                                            ((FieldModel) innerObj).parseFieldVal(innerData);
                                            list.add(innerObj);
                                        } else {
                                            list.add(innerData);
                                        }
                                    }
                                    obj = list;
                                }
                            } else {
                                obj = field.getType().newInstance();
                                ((FieldModel) obj).parseFieldVal(dataSplit);
                            }
                            field.set(this, obj);
                        } catch (InstantiationException | IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    /**
     * @description: 加密压缩
     **/
    public String assembleZip() {
        return Base64Utils.gzipString(this.assemble());
    }

    /**
     * @description: 拼装商品字符串
     **/
    public String assemble() {
        Map<String, Field> fieldMap = this.allAndroidField();
        List<String> keys = this.sortMapKey(fieldMap);
        if (keys != null && !keys.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            keys.forEach(key -> {
                try {
                    Field field = fieldMap.get(key);
                    field.setAccessible(true);
                    Object obj = field.get(this);
                    if (obj != null) {
                        if (obj instanceof FieldModel) {
                            buffer.append(((FieldModel) obj).assembleFieldVal());
                        } else if (obj instanceof List) {
                            buffer.append(DConstant.LIST_SPLIT_START);
                            ((List) obj).forEach(bean -> {
                                if (bean instanceof FieldModel) {
                                    buffer.append(((FieldModel) bean).assembleFieldVal());
                                } else {
                                    buffer.append(bean.toString());
                                }
                                buffer.append(DConstant.LIST_SPLIT);
                            });
                            buffer.append(DConstant.LIST_SPLIT_END);
                        } else {
                            buffer.append(obj.toString());
                        }
                    } else {
                        buffer.append(DConstant.SPACE);
                    }
                    buffer.append(DConstant.FIELD_SPLIT);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            return buffer.substring(0, buffer.length() - 1);
        }
        return null;
    }

    /**
     * @description: 内容数据包解析
     **/
    public static DPLU unzipParse(String data) {
        return new DPLU(data, true);
    }

    /**
     * @description: 数据包内容解析
     **/
    public static DPLU parse(String data) {
        return new DPLU(data, false);
    }

    /**
     * 获取自动折扣对象
     *
     * @param autoDiscount 自动折扣字符串
     * @return
     */
    private static DAutoDiscount getAutoDiscount(String autoDiscount) {
        if (StringUtils.isBlank(autoDiscount)) {
            return null;
        }
        DAutoDiscount dAutoDiscount = new DAutoDiscount();
        // 折扣类型 # 激活日 # 折扣值 # 区间值最小值 # 区间值最大值 #区间类型
        String[] split = StringUtils.split(autoDiscount, "#");
        //折扣类型
        String discountType = split[0];
        //激活日
        String activation = split[1];
        //折扣值
        String discountValue = split[2];
        //区间值最小值
        String min = split[3];
        //区间值最大值
        String max = split[4];
        //区间类型
        String intervalType = null;
        if (split.length > 5) {
            intervalType = split[5];
        }
        dAutoDiscount.setType(getResultInteger(discountType)).setDate(getResultInteger(activation)).setLower
                (getResultBigDecimal(min)).setUpper(getResultBigDecimal(max)).setDiscount(getResultBigDecimal
                (discountValue)).setIntervalType(getResultInteger(intervalType));
        return dAutoDiscount;
    }

    /**
     * @param autoDiscount
     * @return
     */
    @SuppressWarnings("all")
    private static List<DAutoDiscount> getAutoDiscount(String... autoDiscount) {
        if (Objects.isNull(autoDiscount)) {
            return null;
        }
        if (autoDiscount.length <= 0) {
            return null;
        }
        List<DAutoDiscount> autoDiscountList = new ArrayList<>();
        Arrays.stream(autoDiscount).forEach(i -> autoDiscountList.add(getAutoDiscount(i)));
        return autoDiscountList;
    }


    /**
     * 获取手动折扣对象
     *
     * @param manualDiscount 手动折扣字符串
     * @return
     */
    @SuppressWarnings("all")
    private static List<DManualDiscount> getDManualDiscount(String manualDiscount) {
        List<DManualDiscount> manualDiscountList = new ArrayList<>();
        if (StringUtils.isBlank(manualDiscount)) {
            return null;
        }
        String[] split = StringUtils.split(manualDiscount, "|");
        if (Objects.isNull(split) && split.length <= 0) {
            return null;
        }
        // 手动折扣限制
        String dmanualDiscounts = split[0];
        String[] dmanualDiscountss = dmanualDiscounts.split("#");
        // 上限
        String upperLimit = dmanualDiscountss[0];
        // 下限
        String lowerLimit = dmanualDiscountss[1];
        // 上下限折扣类型
        String manualDiscountTypes = split[1];
        String[] manualDiscountTypess = manualDiscountTypes.split("#");
        // 上限折扣类型
        String upperDiscountType = manualDiscountTypess[0];
        // 下限折扣类型
        String lowerDiscountType = manualDiscountTypess[1];
        // 值
        String discounts = split[2];
        String[] discountss = discounts.split("#");
        //  上限值 # 下限值
        // 上限值
        String upperValue = discountss[0];
        // 下限值
        String lowerValue = discountss[1];
        // 添加上限值
        manualDiscountList.add(new DManualDiscount().setDiscount(getResultInteger(upperLimit), getResultInteger
                (upperDiscountType), getResultBigDecimal(upperValue)));
        // 添加下限值
        manualDiscountList.add(new DManualDiscount().setDiscount(getResultInteger(lowerLimit), getResultInteger
                (lowerDiscountType), getResultBigDecimal(lowerValue)));
        return manualDiscountList;
    }


    /**
     * @description: 规格
     **/
    public static class DSpecification extends FieldModel {

        @ApiModelProperty(value = "规格名称", name = "specificationId")
        private Long specificationId;

        @ApiModelProperty(value = "规格名称", name = "name")
        private String name;

        @ApiModelProperty(value = "规格上架状态", name = "specificationState", example = "1-下架 2-上架，3- " + "停售，4 - 缺货 ")
        private String specificationState;

        @ApiModelProperty(value = "比例", name = "ratio")
        private String ratio;

        @ApiModelProperty(value = "主单位信息", name = "masterUnit")
        private Unit masterUnit;
        @ApiModelProperty(value = "副单位信息", name = "secondUnit")
        private Unit secondUnit;

        public Long getSpecificationId() {
            return specificationId;
        }

        public DSpecification setSpecificationId(Long specificationId) {
            this.specificationId = specificationId;
            return this;
        }

        public String getName() {
            return name;
        }

        public DSpecification setName(String name) {
            this.name = name;
            return this;
        }

        public String getSpecificationState() {
            return specificationState;
        }

        public void setSpecificationState(String specificationState) {
            this.specificationState = specificationState;
        }

        public String getRatio() {
            return ratio;
        }

        public DSpecification setRatio(String ratio) {
            this.ratio = ratio;
            return this;
        }

        public Unit getMasterUnit() {
            return masterUnit;
        }

        public void setMasterUnit(Unit masterUnit) {
            this.masterUnit = masterUnit;
        }

        public Unit getSecondUnit() {
            return secondUnit;
        }

        public void setSecondUnit(Unit secondUnit) {
            this.secondUnit = secondUnit;
        }
    }

    /**
     * @description: 单位信息
     **/
    public static class Unit extends FieldModel {

        @ApiModelProperty(value = "单位类型", name = "type")
        private UnitType type;

        @ApiModelProperty(value = "单位唯一识别码", name = "unitCode")
        private Long unitCode;

        @ApiModelProperty(value = "单位值 (条码秤 为秤单位识别码 其余为实际单位)", name = "unit")
        private String unit;

        @ApiModelProperty(value = "条码秤 秤单位识别码翻译信息", name = "dunit")
        private String dunit;

        public Unit() {
        }

        public Unit(UnitEnum unitEnum, Long unitCode, String unit) {
            this.unitCode = unitCode;
            if (UnitType.计件.equals(unitEnum)) {
                this.type = UnitType.计件;
                this.unit = unit;
            } else {
                this.type = UnitType.计重;
                this.unit = unitEnum.getVal();
                this.dunit = unitEnum.getName();
            }
        }

        public Unit(UnitType type, Long unitCode, String unit) {
            this.type = type;
            this.unitCode = unitCode;
            this.unit = unit;
        }

        public Unit(UnitType type, Long unitCode, String unit, String dunit) {
            this.type = type;
            this.unitCode = unitCode;
            this.unit = unit;
            this.dunit = dunit;
        }

        public UnitType getType() {
            return type;
        }

        public Unit setType(UnitType type) {
            this.type = type;
            return this;
        }

        public Long getUnitCode() {
            return unitCode;
        }

        public Unit setUnitCode(Long unitCode) {
            this.unitCode = unitCode;
            return this;
        }

        public String getUnit() {
            return unit;
        }

        public Unit setUnit(String unit) {
            this.unit = unit;
            return this;
        }

        public String getDunit() {
            return dunit;
        }

        public Unit setDunit(String dunit) {
            this.dunit = dunit;
            return this;
        }
    }

    /**
     * @description: 使用日期
     **/
    public static class DUsedate extends DBTimeSetting<DUsedate> {
    }

    /**
     * @description: 类别 组别
     **/
    public static class DCategory extends DBParamSetting<DCategory> {
    }

    /**
     * @description: 部门
     **/
    public static class DDept extends DBParamSetting<DDept> {
    }

    /**
     * @description: 打印格式
     **/
    public static class DPrintType extends DBParamSetting<DPrintType> {
    }

    /**
     * @description: 条码
     **/
    public static class DPrintBarcode extends DBParamSetting<DPrintBarcode> {
    }

    /**
     * @description: 打印信息
     **/
    public static class DPrintInfo extends FieldModel {
        @ApiModelProperty(value = "打印格式", name = "type")
        private DPrintType type;

        @ApiModelProperty(value = "打印条码", name = "barcode")
        private DPrintBarcode barcode;

        @ApiModelProperty(value = "打印标志", name = "sign")
        private Integer sign;

        public DPrintInfo() {
        }

        public DPrintInfo(DPrintType type, DPrintBarcode barcode, Integer sign) {
            this.type = type;
            this.barcode = barcode;
            this.sign = sign;
        }

        public DPrintType getType() {
            return type;
        }

        public DPrintInfo setType(DPrintType type) {
            this.type = type;
            return this;
        }

        public DPrintBarcode getBarcode() {
            return barcode;
        }

        public DPrintInfo setBarcode(DPrintBarcode barcode) {
            this.barcode = barcode;
            return this;
        }

        public Integer getSign() {
            return sign;
        }

        public DPrintInfo setSign(Integer sign) {
            this.sign = sign;
            return this;
        }
    }

    /**
     * @description: 位图信息
     **/
    public static class DBitmap extends DBStrParamSetting<DBitmap> {
    }

    /**
     * @description: 销售日期
     **/
    public static class DSaledate extends DBTimeSetting<DSaledate> {
    }

    /**
     * @description: 销售时间
     **/
    public static class DSaletime extends DBTimeSetting<DSaletime> {
    }

    /**
     * @description: 包装日期
     **/
    public static class DPackdate extends DBTimeSetting<DPackdate> {
    }

    /**
     * @description: 包装时间
     **/
    public static class DPacktime extends DBTimeSetting<DPacktime> {
    }

    /**
     * @description: 手动折扣信息
     **/
    public static class DManualDiscount extends DBParamSetting<DManualDiscount> {

        @ApiModelProperty(value = "手动折扣限制 （0，上限；1-下限）", name = "manualDiscountRestriction")
        private Integer restriction;

        @ApiModelProperty(value = "手动折扣类型 ， 0 ：使用系统设定， 1：无上限 2： 以原始单价为上限 3：已设定数字为上限", name = "manualDiscountType")
        private Integer type;

        @ApiModelProperty(value = "折扣值", name = "discount")
        private BigDecimal discount;

        public DManualDiscount setDiscount(Integer restriction, Integer type, BigDecimal discount) {
            this.restriction = restriction;
            this.type = type;
            this.discount = discount;
            return this;
        }

        public Integer getRestriction() {
            return restriction;
        }

        public Integer getType() {
            return type;
        }

        public BigDecimal getDiscount() {
            return discount;
        }
    }

    /**
     * @description: 自动折扣信息
     **/
    public static class DAutoDiscount extends DBParamSetting<DAutoDiscount> {

        @ApiModelProperty(value = "类型", name = "type")
        private Integer type;

        @ApiModelProperty(value = "激活日 默认 127", name = "date")
        private Integer date;

        @ApiModelProperty(value = "下限", name = "lower")
        private BigDecimal lower;

        @ApiModelProperty(value = "上限", name = "upper")
        private BigDecimal upper;

        @ApiModelProperty(value = "折扣数", name = "discount")
        private BigDecimal discount;

        @ApiModelProperty(value = "区间类型 0:区间内 ,1:区间外", name = "intervalType")
        private Integer intervalType;


        public DAutoDiscount setDate(Integer date) {
            this.date = date;
            return this;
        }

        public DAutoDiscount setLower(BigDecimal lower) {
            this.lower = lower;
            return this;
        }

        public DAutoDiscount setUpper(BigDecimal upper) {
            this.upper = upper;
            return this;
        }

        public DAutoDiscount setDiscount(BigDecimal discount) {
            this.discount = discount;
            return this;
        }

        public DAutoDiscount setType(Integer type) {
            this.type = type;
            return this;
        }

        public DAutoDiscount setIntervalType(Integer intervalType) {
            this.intervalType = intervalType;
            return this;
        }

        public Integer getType() {
            return type;
        }

        public Integer getDate() {
            return date;
        }

        public BigDecimal getLower() {
            return lower;
        }

        public BigDecimal getUpper() {
            return upper;
        }

        public BigDecimal getDiscount() {
            return discount;
        }

        public Integer getIntervalType() {
            return intervalType;
        }

    }

    /**
     * @description: 时间参数设置
     **/
    public static class DBTimeSetting<T extends DBTimeSetting> extends FieldModel {
        @ApiModelProperty(value = "时间数据", name = "val")
        private Integer val;

        public T setVal(Integer val) {
            this.val = val;
            return (T) this;
        }

        public Integer getVal() {
            return val;
        }

        /**
         * @description: 时间参数开启数值
         **/
        public Integer openVal() {
            return Objects.nonNull(this.val) ? 1 : 0;
        }

        /**
         * @description: 时间参数开启
         **/
        public boolean open() {
            return Objects.nonNull(this.val);
        }
    }

    /**
     * @description: 字符串数据参数设置
     **/
    public static class DBStrParamSetting<T extends DBStrParamSetting> extends DBParamSetting<T> {
        @ApiModelProperty(value = "内容", name = "content")
        private String content;

        public String getContent() {
            return content;
        }

        public T setContent(String content) {
            this.content = content;
            return (T) this;
        }
    }

    /**
     * @description: 数值参数设置
     **/
    public static class DBIntParamSetting<T extends DBIntParamSetting> extends DBParamSetting<T> {
        @ApiModelProperty(value = "int 参数值", name = "val")
        private Integer val;

        public T setVal(Integer val) {
            this.val = val;
            return (T) this;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * @description: BigDecimal参数设置
     **/
    public static class DBBigDecimalParamSetting<T extends DBBigDecimalParamSetting> extends DBParamSetting<T> {

        @ApiModelProperty(value = "BigDecimal 参数值", name = "val")
        private BigDecimal val;

        public T setVal(BigDecimal val) {
            this.val = val;
            return (T) this;
        }

        public BigDecimal getVal() {
            return val;
        }
    }

    /**
     * @description: 数据参数设置
     **/
    public static class DBParamSetting<T extends DBParamSetting> extends FieldModel {
        @ApiModelProperty(value = "业务索引编号", name = "id")
        private Long id;

        @ApiModelProperty(value = "设备编号", name = "num")
        private Integer num;

        @ApiModelProperty(value = "名称", name = "name")
        private String name;

        public T setId(Long id) {
            this.id = id;
            return (T) this;
        }

        public T setNum(Integer num) {
            this.num = num;
            return (T) this;
        }

        public T setName(String name) {
            this.name = name;
            return (T) this;
        }

        public Long getId() {
            return id;
        }

        public Integer getNum() {
            return num;
        }

        public String getName() {
            return name;
        }
    }

    public Long getPluNo() {
        return pluNo;
    }

    public void setPluNo(Long pluNo) {
        this.pluNo = pluNo;
    }

    public Long getPluCode() {
        return pluCode;
    }

    public void setPluCode(Long pluCode) {
        this.pluCode = pluCode;
    }

    public String getPluName() {
        return pluName;
    }

    public void setPluName(String pluName) {
        this.pluName = pluName;
    }

    public String getPluState() {
        return pluState;
    }

    public void setPluState(String pluState) {
        this.pluState = pluState;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Unit getUnit() {
        return unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getSimple() {
        return simple;
    }

    public void setSimple(String simple) {
        this.simple = simple;
    }

    public DSpecification getSpecification() {
        return specification;
    }

    public void setSpecification(DSpecification specification) {
        this.specification = specification;
    }

    public String getPictures() {
        return pictures;
    }

    public void setPictures(String pictures) {
        this.pictures = pictures;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getIndexBar() {
        return indexBar;
    }

    public void setIndexBar(String indexBar) {
        this.indexBar = indexBar;
    }

    public DUsedate getUsedate() {
        return usedate;
    }

    public void setUsedate(DUsedate usedate) {
        this.usedate = usedate;
    }

    public BigDecimal getCostTrade() {
        return costTrade;
    }

    public void setCostTrade(BigDecimal costTrade) {
        this.costTrade = costTrade;
    }

    public BigDecimal getTrae() {
        return trae;
    }

    public void setTrae(BigDecimal trae) {
        this.trae = trae;
    }

    public DCategory getCategory() {
        return category;
    }

    public void setCategory(DCategory category) {
        this.category = category;
    }

    public String getSecondCategoryIds() {
        return secondCategoryIds;
    }

    public void setSecondCategoryIds(String secondCategoryIds) {
        this.secondCategoryIds = secondCategoryIds;
    }

    public List<DCategory> getSencondCategorys() {
        return sencondCategorys;
    }

    public void setSencondCategorys(List<DCategory> sencondCategorys) {
        this.sencondCategorys = sencondCategorys;
    }

    public DPrintInfo getPrintInfo1() {
        return printInfo1;
    }

    public void setPrintInfo1(DPrintInfo printInfo1) {
        this.printInfo1 = printInfo1;
    }

    public DPrintInfo getPrintInfo2() {
        return printInfo2;
    }

    public void setPrintInfo2(DPrintInfo printInfo2) {
        this.printInfo2 = printInfo2;
    }

    public List<String> getTexts() {
        return texts;
    }

    public void setTexts(List<String> texts) {
        this.texts = texts;
    }

    public BigDecimal getTaxrate() {
        return taxrate;
    }

    public void setTaxrate(BigDecimal taxrate) {
        this.taxrate = taxrate;
    }

    public DBitmap getBitmap() {
        return bitmap;
    }

    public void setBitmap(DBitmap bitmap) {
        this.bitmap = bitmap;
    }

    public DSaledate getSaledate() {
        return saledate;
    }

    public void setSaledate(DSaledate saledate) {
        this.saledate = saledate;
    }

    public DSaletime getSaletime() {
        return saletime;
    }

    public void setSaletime(DSaletime saletime) {
        this.saletime = saletime;
    }

    public DPackdate getPackdate() {
        return packdate;
    }

    public void setPackdate(DPackdate packdate) {
        this.packdate = packdate;
    }

    public DPacktime getPacktime() {
        return packtime;
    }

    public void setPacktime(DPacktime packtime) {
        this.packtime = packtime;
    }

    public String getManualDiscount() {
        return manualDiscount;
    }

    /**
     * @description: 获取手动折扣方法
     **/
    public List<DManualDiscount> getManualdiscount() {
        return DPLU.getDManualDiscount(manualDiscount);
    }

    public void setManualDiscount(String manualDiscount) {
        this.manualDiscount = manualDiscount;
    }

    public String getAutoDiscount1() {
        return autoDiscount1;
    }

    /**
     * @description: 获取自动折扣1
     **/
    public DAutoDiscount getAutodiscount1() {
        return DPLU.getAutoDiscount(autoDiscount1);
    }

    public void setAutoDiscount1(String autoDiscount1) {
        this.autoDiscount1 = autoDiscount1;
    }

    public String getAutoDiscount2() {
        return autoDiscount2;
    }

    /**
     * @description: 获取自动折扣2
     **/
    public DAutoDiscount getAutodiscount2() {
        return DPLU.getAutoDiscount(autoDiscount2);
    }

    public void setAutoDiscount2(String autoDiscount2) {
        this.autoDiscount2 = autoDiscount2;
    }

    public String getAutoDiscount3() {
        return autoDiscount3;
    }

    /**
     * @description: 获取自动折扣3
     **/
    public DAutoDiscount getAutodiscount3() {
        return DPLU.getAutoDiscount(autoDiscount3);
    }

    public void setAutoDiscount3(String autoDiscount3) {
        this.autoDiscount3 = autoDiscount3;
    }

    public String getAutoDiscount4() {
        return autoDiscount4;
    }

    /**
     * @description: 获取自动折扣4
     **/
    public DAutoDiscount getAutodiscount4() {
        return DPLU.getAutoDiscount(autoDiscount4);
    }

    public void setAutoDiscount4(String autoDiscount4) {
        this.autoDiscount4 = autoDiscount4;
    }
}
