package com.jhscale.common.model.device;

import com.jhscale.common.ysscale.UnitEnum;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author lie_w
 * @title: UnitType
 * @projectName common
 * @description: TODO
 * @date 2021-02-2610:00
 */
public enum UnitType {
    计重(1, "计重"), 计件(2, "计件");

    private final Integer val;

    private final String description;

    private static final Map<String, UnitType> MAP = new HashMap<>();

    static {

        for (UnitType type : values()) {
            MAP.put(type.description, type);
        }
    }

    UnitType(Integer val, String description) {
        this.val = val;
        this.description = description;
    }

    public Integer getVal() {
        return val;
    }

    public String getDescription() {
        return description;
    }

    public static UnitType valueOfName(String name) {
        return MAP.get(name.replace("\"", ""));
    }

    public static UnitType getUnitType(Integer state) {
        if (Objects.isNull(state)) {
            return null;
        }
        for (UnitType transactType : values()) {
            if (transactType.getVal().equals(state)) {
                return transactType;
            }
        }
        return null;
    }
}
