package com.jhscale.common.model.device._inner;

import com.jhscale.common.model.inter.JSONModel;
import org.apache.commons.lang3.StringUtils;

import static com.jhscale.common.model.device.DConstant.PUBLIC_FIELD_SPLIT_2;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title AIValue
 * @description
 * @create 2023/8/31 9:05
 */
public class AIValue implements JSONModel, Comparable<AIValue> {

    // 标签
    private String label;

    // 数值
    private float value;

    public AIValue() {
    }

    public AIValue(float value) {
        this.value = value;
    }

    public AIValue(String label, float value) {
        this.label = label;
        this.value = value;
    }

    public AIValue(String part) {
        String[] split = part.split(PUBLIC_FIELD_SPLIT_2);
        if (split.length == 1) {
            this.value = Float.parseFloat(split[0]);
        } else {
            this.value = Float.parseFloat(split[0]);
            this.label = split[1];
        }
    }

    /**
     * @description: 数据内容信息
     **/
    public String part() {
        return this.value + (StringUtils.isNotBlank(this.label) ? (PUBLIC_FIELD_SPLIT_2 + this.label) : "");
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public float getValue() {
        return value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "AIValue{" +
                "label='" + label + '\'' +
                ", value=" + value +
                '}';
    }

    /**
     * Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.
     *
     * <p>The implementor must ensure <tt>sgn(x.compareTo(y)) ==
     * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
     * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
     * <tt>y.compareTo(x)</tt> throws an exception.)
     *
     * <p>The implementor must also ensure that the relation is transitive:
     * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
     * <tt>x.compareTo(z)&gt;0</tt>.
     *
     * <p>Finally, the implementor must ensure that <tt>x.compareTo(y)==0</tt>
     * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
     * all <tt>z</tt>.
     *
     * <p>It is strongly recommended, but <i>not</i> strictly required that
     * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
     * class that implements the <tt>Comparable</tt> interface and violates
     * this condition should clearly indicate this fact.  The recommended
     * language is "Note: this class has a natural ordering that is
     * inconsistent with equals."
     *
     * <p>In the foregoing description, the notation
     * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
     * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
     * <tt>0</tt>, or <tt>1</tt> according to whether the value of
     * <i>expression</i> is negative, zero or positive.
     *
     * @param o the object to be compared.
     * @return a negative integer, zero, or a positive integer as this object
     * is less than, equal to, or greater than the specified object.
     * @throws NullPointerException if the specified object is null
     * @throws ClassCastException   if the specified object's type prevents it
     *                              from being compared to this object.
     */
    @Override
    public int compareTo(AIValue o) {
        return Float.compare(o.value, this.value);
    }
}
