package com.jhscale.common.model.device._inner;

import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.utils.DDataUtils;
import io.swagger.annotations.ApiModel;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @title: PublicExecute
 * @projectName common
 * @description: TODO
 * @date 2023/1/1422:56
 */
@ApiModel("公开协议操作")
public abstract class PublicExecute implements GJSONModel {

    // @ApiModelProperty(value = "数据类型", name = "type")
    private String type;

    // @ApiModelProperty(value = "执行类型", name = "execute")
    private String execute;

    // @ApiModelProperty(value = "序号版本", name = "serial")
    private int serial;

    public PublicExecute() {
    }

    public PublicExecute(String type, String execute) {
        if (StringUtils.isNotBlank(type))
            this.type = type.trim();
        if (StringUtils.isNotBlank(execute))
            this.execute = execute.trim();
    }

    public PublicExecute(String type, String execute, int serial) {
        this(type, execute);
        this.serial = serial;
    }

    /**
     * @description: 有效操作对象数据
     **/
    public boolean valid() {
        return true;
    }

    /**
     * @description: 移除第一个
     **/
    public <T extends DataJSONModel> T remove_first(Class<T> clazz) {
        return null;
    }

    /**
     * @description: 内容组装
     **/
    public String Package() {
        return "";
    }

    /**
     * @description: 不使用反射
     **/
    public String Package_No_Reflex() {
        return this.Package();
    }

    /**
     * @description: 重写数据发送
     **/
    public String Package_No_Reflex(int start, int end) {
        return this.Package_No_Reflex();
    }

    /**
     * @description: 头数据
     **/
    public String Package_No_Reflex_Top() {
        return new StringBuffer().append(this.getExecute())
                .append(PUBLIC_FIELD_SPLIT)
                .append(this.getType())
                .append(PUBLIC_FIELD_SPLIT)
                .append(PUBLIC_LINE_SPLIT)
                .toString();
    }

    /**
     * @description: 内容数据
     **/
    public String Package_No_Reflex_Body() {
        return "";
    }

    /**
     * @description: 清空缓冲
     **/
    public void clear() {
    }

    /**
     * @description: 尾数据
     **/
    public String Package_No_Reflex_Tail() {
        return new StringBuffer().append(PUBLIC_END)
                .append(PUBLIC_FIELD_SPLIT)
                .append(DDataUtils.getSpDWL(this.getType()) != null ? PUBLIC_MDF : this.getType())
                .append(PUBLIC_FIELD_SPLIT)
                .append(PUBLIC_LINE_SPLIT)
                .toString();
    }

    /**
     * @description: 数量大小
     **/
    public int size() {
        return 0;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getExecute() {
        return execute;
    }

    public void setExecute(String execute) {
        this.execute = execute;
    }

    public int getSerial() {
        return serial;
    }

    public void setSerial(int serial) {
        if (serial == 0 && this.serial != 0) return;
        this.serial = serial;
    }

    /**
     * @description: 深度拷贝
     **/
    public PublicExecute clone() {
        Class<? extends PublicExecute> clazz = this.getClass();
        try {
            PublicExecute copy = clazz.newInstance();
            copy.setType(this.getType());
            copy.setExecute(this.getExecute());
            copy.setSerial(this.getSerial());
            return copy;
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * @description: 写入操作
     **/
    @Deprecated
    protected String write(List<DataJSONModel> models) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getExecute())
                .append(PUBLIC_FIELD_SPLIT)
                .append(this.getType())
                .append(PUBLIC_FIELD_SPLIT)
                .append(PUBLIC_LINE_SPLIT);
        if (models != null && !models.isEmpty()) {
            for (DataJSONModel model : models) {
                buffer.append(model.Public_Package());
            }
        }
        buffer.append(PUBLIC_END)
                .append(PUBLIC_FIELD_SPLIT)
                .append(this.getType())
                .append(PUBLIC_FIELD_SPLIT)
                .append(PUBLIC_LINE_SPLIT);
        return buffer.toString();
    }

    /**
     * @description: 文本操作
     **/
    protected String content(List<String> contents) {
        StringBuffer buffer = new StringBuffer();
        for (String id : contents) {
            buffer.append(this.getExecute())
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(this.getType())
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(id)
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(PUBLIC_LINE_SPLIT);
        }
        buffer.append(PUBLIC_END)
                .append(PUBLIC_FIELD_SPLIT)
                .append(this.getType())
                .append(PUBLIC_FIELD_SPLIT)
                .append(PUBLIC_LINE_SPLIT);
        return buffer.toString();
    }

    /**
     * @description: 文本操作
     **/
    protected String content_body(List<String> contents) {
        StringBuffer buffer = new StringBuffer();
        if (contents != null && !contents.isEmpty()) {
            for (String id : contents) {
                buffer.append(this.getExecute())
                        .append(PUBLIC_FIELD_SPLIT)
                        .append(this.getType())
                        .append(PUBLIC_FIELD_SPLIT)
                        .append(id)
                        .append(PUBLIC_FIELD_SPLIT)
                        .append(PUBLIC_LINE_SPLIT);
            }
        }
        return buffer.toString();
    }

    /**
     * @description: 索引操作
     **/
    public String index(List<Integer> ids) {
        StringBuffer buffer = new StringBuffer();
        if (ids == null || ids.isEmpty() /*|| ids.contains(0)*/)
            ids = Arrays.asList(0);
        for (Integer id : ids) {
            buffer.append(this.getExecute())
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(this.getType())
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(id)
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(PUBLIC_LINE_SPLIT);
        }
        buffer.append(PUBLIC_END)
                .append(PUBLIC_FIELD_SPLIT)
                .append(this.getExecute())
                .append(PUBLIC_FIELD_SPLIT)
                .append(PUBLIC_LINE_SPLIT);
        return buffer.toString();
    }

    /**
     * @description: 索引操作
     **/
    public String index_body(List<Integer> ids) {
        StringBuffer buffer = new StringBuffer();
        if (ids == null || ids.isEmpty() || ids.contains(0))
            ids = Arrays.asList(0);
        for (Integer id : ids) {
            buffer.append(this.getExecute())
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(this.getType())
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(id)
                    .append(PUBLIC_FIELD_SPLIT)
                    .append(PUBLIC_LINE_SPLIT);
        }
        return buffer.toString();
    }
}
