package com.jhscale.common.model.device._inner;

import io.swagger.annotations.ApiModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.PUBLIC_ASK;

/**
 * @author wang lie
 * @title: AddPublicExecute
 * @projectName common
 * @description: TODO
 * @date 2023/1/1422:59
 */
@ApiModel("公开协议请求操作")
public class PublicExecuteAsk extends PublicExecute {

    // @ApiModelProperty(value = "请求操作内容", name = "contents")
    private List<String> contents;

    public PublicExecuteAsk() {
        super(null, PUBLIC_ASK);
    }

    public PublicExecuteAsk(String type) {
        super(type, PUBLIC_ASK);
    }


    /**
     * @description: 添加模型
     **/
    public PublicExecuteAsk add(String... contents) {
        if (contents != null && contents.length > 0) {
            if (this.contents == null) this.contents = new ArrayList<>();
            this.contents.addAll(Arrays.asList(contents));
        }
        return this;
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public String Package() {
        return this.content(this.contents);
    }

    /**
     * @description: 头数据
     **/
    @Override
    public String Package_No_Reflex_Top() {
        return "";
    }

    /**
     * @description: 内容数据
     **/
    @Override
    public String Package_No_Reflex_Body() {
        return this.content_body(this.contents);
    }

    @Override
    public void clear() {
        if (this.contents != null && !this.contents.isEmpty()) {
            this.contents.clear();
        }
    }

    /**
     * @description: 深度拷贝
     **/
    @Override
    public PublicExecute clone() {
        PublicExecute clone = super.clone();
        if (clone != null)
            ((PublicExecuteAsk) clone).setContents(this.getContents());
        return clone;
    }

    /**
     * @description: 数量大小
     **/
    @Override
    public int size() {
        return Objects.isNull(this.contents) ? 0 : this.contents.size();
    }

    public List<String> getContents() {
        return contents;
    }

    public void setContents(List<String> contents) {
        this.contents = contents;
    }
}
