package com.jhscale.common.model.device._inner;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.DDataUtils;
import io.swagger.annotations.ApiModel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @title: AddPublicExecute
 * @projectName common
 * @description: TODO
 * @date 2023/1/1422:59
 */
@ApiModel("公开协议变更操作")
public class PublicExecuteModify extends PublicExecute {

    // @ApiModelProperty(value = "数据模型对象", name = "models")
    private List<DataJSONModel> models;

    // private int lastNo;

    public PublicExecuteModify() {
        super(null, PUBLIC_MDF);
    }

    public PublicExecuteModify(String type) {
        super(type, PUBLIC_MDF);
    }

    public PublicExecuteModify(String type, DataJSONModel... models) {
        this(type);
        this.add(models);
    }

    /**
     * @description: 添加模型
     **/
    public PublicExecuteModify add(DataJSONModel... models) {
        if (models != null && models.length > 0) {
            this.add(Arrays.asList(models));
        }
        return this;
    }

    public PublicExecuteModify add(List<DataJSONModel> models) {
        if (models != null && !models.isEmpty()) {
            if (this.models == null) this.models = new ArrayList<>();
            this.models.addAll(models);
            try {
                // this.lastNo = models.get(models.size() - 1).no();
                this.setSerial(models.get(0).getClass().getAnnotation(DataClass.class).serial());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    /**
     * @description: 有效操作对象数据
     **/
    @Override
    public boolean valid() {
        return this.models != null && !this.models.isEmpty();
    }

    /**
     * @description: 移除第一个
     **/
    @Override
    public <T extends DataJSONModel> T remove_first(Class<T> clazz) {
        try {
            return this.models != null && !this.models.isEmpty() ?
                    (T) this.models.remove(0)
                    : clazz.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public String Package() {
        List<Field> fields = null;
        // Class clazz = DDataUtils.typeToClazz(this.getType());
        // try {
        //     if (clazz != null) {
        //         DataJSONModel jsonModel = (DataJSONModel) clazz.newInstance();
        //         fields = jsonModel.Public_Fields();
        //     }
        // } catch (InstantiationException | IllegalAccessException e) {
        //     e.printStackTrace();
        // }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getExecute())
                .append(PUBLIC_FIELD_SPLIT)
                .append(this.getType())
                .append(PUBLIC_LINE_SPLIT);
        if (models != null && !models.isEmpty()) {
            for (DataJSONModel model : models) {
                if (fields != null) {
                    buffer.append(model.Public_Package(fields));
                } else {
                    buffer.append(model.Public_Package());
                }
            }
        }
        buffer.append(PUBLIC_END)
                .append(PUBLIC_FIELD_SPLIT)
                .append(this.getType())
                .append(PUBLIC_LINE_SPLIT);
        return buffer.toString();
    }

    /**
     * @description: 不使用反射
     **/
    @Override
    public String Package_No_Reflex() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getExecute())
                .append(PUBLIC_FIELD_SPLIT)
                .append(this.getType())
                .append(PUBLIC_FIELD_SPLIT)
                .append(PUBLIC_LINE_SPLIT);

        buffer.append(this.Package_No_Reflex_Body());

        buffer.append(PUBLIC_END)
                .append(PUBLIC_FIELD_SPLIT)
                .append(DDataUtils.getSpDWL(this.getType()) != null ? PUBLIC_MDF : this.getType())
                .append(PUBLIC_FIELD_SPLIT)
                .append(PUBLIC_LINE_SPLIT);
        return buffer.toString();
    }

    /**
     * @param start
     * @param end
     * @description: 重写数据发送
     */
    @Override
    public String Package_No_Reflex(int start, int end) {
        if (start == 0 && end == this.models.size()) {
            return this.Package_No_Reflex();
        } else {
            StringBuffer buffer = new StringBuffer();
            if (start == 0) {
                buffer.append(this.getExecute())
                        .append(PUBLIC_FIELD_SPLIT)
                        .append(this.getType())
                        .append(PUBLIC_LINE_SPLIT);
            }

            for (DataJSONModel model : this.models.subList(start, end)) {
                StringBuilder builder = model.Public_Package_No_Reflex();
                if (builder.length() == 0) {
                    buffer.append(model.Public_Package());
                } else {
                    buffer.append(builder);
                }
            }

            if (end == this.models.size()) {
                buffer.append(PUBLIC_END)
                        .append(PUBLIC_FIELD_SPLIT)
                        .append(this.getType())
                        .append(PUBLIC_LINE_SPLIT);
            }
            return buffer.toString();
        }
    }

    /**
     * @description: 内容数据
     **/
    @Override
    public String Package_No_Reflex_Body() {
        StringBuffer buffer = new StringBuffer();
        if (models != null && !models.isEmpty()) {
            for (DataJSONModel model : models) {
                StringBuilder builder = model.Public_Package_No_Reflex();
                if (builder.length() == 0) {
                    buffer.append(model.Public_Package());
                } else {
                    buffer.append(builder);
                }
            }
        }
        return buffer.toString();
    }

    @Override
    public void clear() {
        if (this.models != null && !models.isEmpty()) {
            this.models.clear();
        }
    }

    /**
     * @description: 深度拷贝
     **/
    @Override
    public PublicExecute clone() {
        PublicExecute clone = super.clone();
        if (clone != null)
            ((PublicExecuteModify) clone).setModels(this.getModels());
        return clone;
    }

    /**
     * @description: 数量大小
     **/
    @Override
    public int size() {
        return Objects.isNull(this.models) ? 0 : this.models.size();
    }

    public List<DataJSONModel> getModels() {
        return models;
    }

    public void setModels(List<DataJSONModel> models) {
        this.models = models;
    }

    // public int getLastNo() {
    //     if (this.models != null && !models.isEmpty()) {
    //         int no = this.models.get(this.models.size() - 1).no();
    //         if (this.lastNo == 0 || no > this.lastNo) this.lastNo = no;
    //     }
    //     return lastNo;
    // }

    // public void setLastNo(int lastNo) {
    //    this.lastNo = lastNo;
    // }
}
