package com.jhscale.common.model.device._inner;

import io.swagger.annotations.ApiModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.PUBLIC_MDF;

/**
 * @author wang lie
 * @title: AddPublicExecute
 * @projectName common
 * @description: TODO
 * @date 2023/1/1422:59
 */
@ApiModel("公开协议变更操作缓冲")
public class PublicExecuteModifyCache extends PublicExecute {

    // @ApiModelProperty(value = "数据模型对象", name = "contents")
    private List<String[]> lines;

    public PublicExecuteModifyCache() {
        super(null, PUBLIC_MDF);
    }

    public PublicExecuteModifyCache(String type) {
        super(type, PUBLIC_MDF);
    }

    public PublicExecuteModifyCache(String type, String[]... lines) {
        this(type);
        this.add(lines);
    }

    /**
     * @description: 添加模型
     **/
    public PublicExecuteModifyCache add(String[]... lines) {
        if (lines != null && lines.length > 0) {
            this.add(Arrays.asList(lines));
        }
        return this;
    }

    public PublicExecuteModifyCache add(List<String[]> lines) {
        if (lines != null && !lines.isEmpty()) {
            if (this.lines == null) this.lines = new ArrayList<>();
            this.lines.addAll(lines);
        }
        return this;
    }

    /**
     * @description: 有效操作对象数据
     **/
    @Override
    public boolean valid() {
        return this.lines != null && !this.lines.isEmpty();
    }

    @Override
    public void clear() {
        if (this.lines != null && !this.lines.isEmpty()) {
            this.lines.clear();
        }
    }

    /**
     * @description: 深度拷贝
     **/
    @Override
    public PublicExecute clone() {
        PublicExecute clone = super.clone();
        if (clone != null)
            ((PublicExecuteModifyCache) clone).setLines(this.getLines());
        return clone;
    }

    /**
     * @description: 数量大小
     **/
    @Override
    public int size() {
        return Objects.isNull(this.lines) ? 0 : this.lines.size();
    }

    public List<String[]> getLines() {
        return lines;
    }

    public void setLines(List<String[]> lines) {
        this.lines = lines;
    }
}
