package com.jhscale.common.model.device._inner;

import io.swagger.annotations.ApiModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.PUBLIC_UPL;

/**
 * @author wang lie
 * @title: AddPublicExecute
 * @projectName common
 * @description: TODO
 * @date 2023/1/1422:59
 */
@ApiModel("公开协议回收操作")
public class PublicExecuteRecovery extends PublicExecute {

    // @ApiModelProperty(value = "回收ID Null 回收全部", name = "ids")
    private List<Integer> ids;

    public PublicExecuteRecovery() {
        super(null, PUBLIC_UPL);
    }

    public PublicExecuteRecovery(String type) {
        super(type, PUBLIC_UPL);
    }

    public PublicExecuteRecovery(String type, Integer... ids) {
        this(type);
        this.add(ids);
    }

    /**
     * @description: 添加回收id
     **/
    public PublicExecuteRecovery add(Integer... ids) {
        if (ids != null && ids.length > 0) {
            return this.add(Arrays.asList(ids));
        }
        return this;
    }

    public PublicExecuteRecovery add(List<Integer> ids) {
        if (ids != null && !ids.isEmpty()) {
            for (Integer id : ids) {
                if (this.ids == null) this.ids = new ArrayList<>();
                this.ids.add(id);
            }
        }
        return this;
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public String Package() {
        return this.index(this.ids);
    }

    /**
     * @description: 头数据
     **/
    @Override
    public String Package_No_Reflex_Top() {
        return "";
    }

    /**
     * @description: 内容数据
     **/
    @Override
    public String Package_No_Reflex_Body() {
        return this.index_body(this.ids);
    }

    @Override
    public void clear() {
        if (this.ids != null && !this.ids.isEmpty()) {
            this.ids.clear();
        }
    }


    /**
     * @description: 深度拷贝
     **/
    @Override
    public PublicExecute clone() {
        PublicExecute clone = super.clone();
        if (clone != null)
            ((PublicExecuteRecovery) clone).setIds(this.getIds());
        return clone;
    }

    /**
     * @description: 数量大小
     **/
    @Override
    public int size() {
        return Objects.isNull(this.ids) ? 0 : this.ids.size();
    }

    public List<Integer> getIds() {
        return ids;
    }

    public void setIds(List<Integer> ids) {
        this.ids = ids;
    }
}
