package com.jhscale.common.model.device._inner;

import com.jhscale.common.model.inter.GJSONModel;

import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: UnPackageResponse
 * @projectName common
 * @description: TODO
 * @date 2023/3/715:37
 */
public class UnPackageResponse implements GJSONModel {

    // 数据包内容
    private List<PublicExecute> executes;

    // 数据包剩余内容
    private String surplus;

    public UnPackageResponse() {
    }

    public UnPackageResponse(List<PublicExecute> executes, String surplus) {
        this.executes = executes;
        this.surplus = surplus;
    }

    /**
     * @description: 数量
     **/
    public int size() {
        return Objects.isNull(this.executes) ? 0 : this.executes.size();
    }

    public List<PublicExecute> getExecutes() {
        return executes;
    }

    public void setExecutes(List<PublicExecute> executes) {
        this.executes = executes;
    }

    public String getSurplus() {
        return surplus;
    }

    public void setSurplus(String surplus) {
        this.surplus = surplus;
    }
}
