package com.jhscale.common.model.device.ai_feature;

import com.jhscale.common.model.device._inner.AIValue;
import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.device.plu.param.Prepose;
import com.jhscale.common.model.inter.DataJSONModel;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.jhscale.common.content.JHContents.AI_Algorithm_Type_Feature;
import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @title: DAIFeature
 * @projectName common
 * @description: AI特征信息
 * @date 2023/7/233:46
 */
public interface DAIFeature<T extends DAIFeature> extends DataJSONModel<T> {

    /**
     * @description: 对象前置对象处理
     **/
    @Override
    default Prepose prepose() {
        if (this.getFeature_specials() == null) {
            this.mapToArray();
        }
        return new Prepose();
    }

    /**
     * @param serial
     * @description: 默认组装方法1
     */
    @Override
    default String package_method(int serial) {
        StringBuffer buffer = new StringBuffer();
        switch (serial) {
            case 0:
                buffer.append(this.weight());
                break;
            case 1:
                buffer.append(this.specials());
                break;
            case 2:
                buffer.append(this.counter());
                break;
            case 3:
                buffer.append(this.creates());
                break;
        }
        return buffer.toString();
    }

    /**
     * @description: 权重字符内容
     **/
    default String weight() {
        String weightStr = "";
        if (this.getWeight() != null && this.getWeight().length > 0) {
            for (int i = 0; i < this.getWeight().length; i++) {
                weightStr += this.getWeight()[i] + (i != this.getWeight().length - 1 ? PUBLIC_FIELD_SPLIT_3 : "");
            }
        }
        return weightStr;
    }

    /**
     * @description: 特征值转字符内容
     **/
    default String specials() {
        String featureStr = "";
        if (this.getFeature_specials() != null && this.getFeature_specials().length > 0) {
            for (int i = 0; i < this.getFeature_specials().length; i++) {
                featureStr += this.getFeature_specials()[i]
                        + (i != this.getFeature_specials().length - 1 ? PUBLIC_FIELD_SPLIT_4 : "");
            }
        }
        return featureStr;
    }

    /**
     * @description: 计数器字符内容
     **/
    default String counter() {
        String counterStr = "";
        if (this.getCounter() != null && this.getCounter().length > 0) {
            for (int i = 0; i < this.getCounter().length; i++) {
                counterStr += this.getCounter()[i] + (i != this.getCounter().length - 1 ? PUBLIC_FIELD_SPLIT_3 : "");
            }
        }
        return counterStr;
    }

    /**
     * @description: 创建时间字符内容
     **/
    default String creates() {
        String createsStr = "";
        if (this.getCreates() != null && this.getCreates().length > 0) {
            for (int i = 0; i < this.getCreates().length; i++) {
                createsStr += this.getCreates()[i] + (i != this.getCreates().length - 1 ? PUBLIC_FIELD_SPLIT_3 : "");
            }
        }
        return createsStr;
    }

    /**
     * @param contents
     * @param serial
     * @description: 默认拆解方法1
     */
    @Override
    default PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        switch (serial) {
            case 0:
                unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                String[] contents_0 = ((PublicUnPackageArray) unPackage).getContents();
                if (StringUtils.isNotBlank(contents_0[0])) this.weight(contents_0[0]);
                break;
            case 1:
                unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                String[] contents_1 = ((PublicUnPackageArray) unPackage).getContents();
                if (StringUtils.isNotBlank(contents_1[0])) this.feature_specials(contents_1[0]);
                break;
            case 2:
                unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                String[] contents_2 = ((PublicUnPackageArray) unPackage).getContents();
                if (StringUtils.isNotBlank(contents_2[0])) this.counter(contents_2[0]);
                break;
            case 3:
                unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                String[] contents_3 = ((PublicUnPackageArray) unPackage).getContents();
                if (StringUtils.isNotBlank(contents_3[0])) this.creates(contents_3[0]);
                break;
        }
        return unPackage;
    }

    /**
     * @description: 权重内容
     **/
    default void weight(String weightStr) {
        if (StringUtils.isNotBlank(weightStr)) {
            String[] weightArr = weightStr.split(PUBLIC_FIELD_SPLIT_3);
            int[] weight = new int[weightArr.length];
            for (int i = 0; i < weightArr.length; i++) {
                weight[i] = Integer.parseInt(weightArr[i]);
            }
            this.setWeight(weight);
        }
    }

    /**
     * @description: 特征值内容
     **/
    default void feature_specials(String i_featureStr) {
        if (StringUtils.isNotBlank(i_featureStr)) {
            this.setFeature_specials(i_featureStr.split(PUBLIC_FIELD_SPLIT_4_1));
        }
    }

    /**
     * @description: 计数器内容
     **/
    default void counter(String counterStr) {
        if (StringUtils.isNotBlank(counterStr)) {
            String[] counterArr = counterStr.split(PUBLIC_FIELD_SPLIT_3);
            int[] counter = new int[counterArr.length];
            for (int i = 0; i < counterArr.length; i++) {
                counter[i] = Integer.parseInt(counterArr[i]);
            }
            this.setCounter(counter);
        }
    }

    /**
     * @description: 创建时间内容
     **/
    default void creates(String createsStr) {
        if (StringUtils.isNotBlank(createsStr)) {
            String[] createsArr = createsStr.split(PUBLIC_FIELD_SPLIT_3);
            String[] creates = new String[createsArr.length];
            for (int i = 0; i < createsArr.length; i++) {
                creates[i] = createsArr[i];
            }
            this.setCreates(creates);
        }
    }


    /**
     * @description: label 标签
     **/
    default String label_str() {
        return String.format("%s_%s", this.getLabel_name(), this.getNick_name());
    }

    /**
     * @description: map => array
     **/
    default T mapToArray() {
        String[] species = new String[this.getCounter().length];
        Map<Integer, Map<Integer, List<AIValue>>> self_values = this.getSelf_values();
        if (self_values != null && !self_values.isEmpty()) {
            for (Map.Entry<Integer, Map<Integer, List<AIValue>>> entry : self_values.entrySet()) {

                Integer algorithm_type = entry.getKey();
                Map<Integer, List<AIValue>> value = entry.getValue();

                if (value != null && !value.isEmpty()) {
                    int index = 0;
                    for (Map.Entry<Integer, List<AIValue>> innerEntry : value.entrySet()) {
                        Integer serial = innerEntry.getKey();
                        List<AIValue> innerValues = innerEntry.getValue();

                        if (innerValues != null && !innerValues.isEmpty()) {
                            String part = algorithm_type + PUBLIC_FIELD_SPLIT_1 + serial + PUBLIC_FIELD_SPLIT_1;
                            for (int i = 0; i < innerValues.size(); i++) {
                                part += innerValues.get(i).part()
                                        + ((i != innerValues.size() - 1) ? PUBLIC_FIELD_SPLIT_3 : "");
                            }
                            species[index] = part;
                        }
                        index++;
                    }
                }
            }
        }
        this.setFeature_specials(species);
        return (T) this;
    }

    /**
     * @description: array => map
     **/
    default T arrayToMap() {
        Map<Integer, Map<Integer, List<AIValue>>> self_values = new HashMap<>();
        String[] specials = this.getFeature_specials();
        if (specials != null && specials.length != 0) {
            for (int i = 0; i < specials.length; i++) {

                String special = specials[i].replace("[", "")
                        .replace("]", "");

                String[] split = special.split(PUBLIC_FIELD_SPLIT_1);

                if (split.length == 0) continue;

                Integer algorithm_type = split.length == 1 ? AI_Algorithm_Type_Feature : Integer.parseInt(split[0]);
                Integer serial = split.length == 1 ? i : Integer.parseInt(split[1]);
                String feature = split.length == 1 ? special : split[2];
                specials[i] = feature;

                Map<Integer, List<AIValue>> innerMap = self_values.get(algorithm_type);
                if (innerMap == null) {
                    innerMap = new HashMap<>();
                    self_values.put(algorithm_type, innerMap);
                }

                String[] parts = feature.split(PUBLIC_FIELD_SPLIT_3);
                List<AIValue> values = new ArrayList<>();
                for (String part : parts) {
                    values.add(new AIValue(part));
                }
                innerMap.put(serial, values);
            }
        }
        this.setSelf_values(self_values);
        return (T) this;
    }

    /**
     * @description: 使用计数器添加
     **/
//    default void add_counter(int index) {
//        int[] counter = this.getCounter();
//        if (counter == null || counter.length <= index) {
//            int[] _counter = new int[index + 1];
//            if (counter != null && counter.length > 0) {
//                for (int i = 0; i < counter.length; i++) {
//                    _counter[i] = counter[i];
//                }
//            }
//            this.setCounter(_counter);
//            this.add_counter(index);
//        } else {
//            counter[index]++;
//        }
//    }

    /**
     * @description: 移除特征
     **/
//    default void remove_feature(int index) {
//        int[] weight = this.getWeight();
//
//        String[][] feature_specials = this.getSpecials();
//        feature_specials[0] = MathUtils.calculateColumnAverages(feature_specials[0], weight[0], feature_specials[index], weight[index]);
//        weight[0] -= weight[index];
//        feature_specials = ByteUtils.removeMerger(feature_specials, index);
//        this.setFeature_specials(feature_specials);
//
//        weight = ByteUtils.removeMerger(weight, index);
//        this.setWeight(weight);
//
//        int[] counter = this.getCounter();
//        counter = ByteUtils.removeMerger(counter, index);
//        this.setCounter(counter);
//
//        String[] creates = this.getCreates();
//        creates = ByteUtils.removeMerger(creates, index);
//        this.setCreates(creates);
//
//        float[] other_feature_specials = this.getOther_feature_specials();
//        other_feature_specials = ByteUtils.removeMerger(other_feature_specials, index);
//        other_feature_specials[0] = MathUtils.calculate31(feature_specials[0]);
//        this.setOther_feature_specials(other_feature_specials);
//    }

//    /**
//     * @description: 添加采样项
//     **/
//    default void add_feature(float[] feature) {
//        // 权重参数
//        int[] weight = this.getWeight();
//
//        if (weight == null || weight.length == 0) weight = new int[1];
//        int[] _weight = new int[weight.length + 1];
//        for (int i = 0; i < weight.length; i++) {
//            _weight[i] = weight[i];
//        }
//        this.setWeight(_weight);
//
//        // 使用次数
//        int[] counter = this.getCounter();
//        if (counter == null || counter.length == 0) counter = new int[1];
//        int[] _counter = new int[counter.length + 1];
//        for (int i = 0; i < counter.length; i++) {
//            _counter[i] = counter[i];
//        }
//        this.setCounter(_counter);
//
//        // 创建时间
//        String yyMMdd = DateUtils.getDate_YYMMDD(new Date());
//        String[] creates = this.getCreates();
//        if (creates == null || creates.length == 0) creates = new String[]{yyMMdd};
//        String[] _creates = new String[creates.length + 1];
//        for (int i = 0; i < creates.length; i++) {
//            _creates[i] = creates[i];
//        }
//        _creates[_creates.length - 1] = yyMMdd;
//        this.setCreates(_creates);
//
//        // 特征值
//        float[][] feature_specials = this.getFeature_specials();
//        if (feature_specials == null || feature_specials.length == 0) feature_specials = new float[1][];
//        float[][] _feature_specials = new float[feature_specials.length + 1][];
//        for (int i = 0; i < feature_specials.length; i++) {
//            _feature_specials[i] = feature_specials[i];
//        }
//        _feature_specials[_feature_specials.length - 1] = feature;
//        this.setFeature_specials(_feature_specials);
//
//        // 平均值
//        _feature_specials[0] = MathUtils.calculateColumnAverages(feature_specials[0], weight[0], feature);
//        _weight[0]++;
//
//        float[] other_feature_specials = this.getOther_feature_specials();
//        if (other_feature_specials == null || other_feature_specials.length == 0) other_feature_specials = new float[1];
//        float[] _other_feature_specials = new float[other_feature_specials.length + 1];
//        for (int i = 0; i < other_feature_specials.length; i++) {
//            _other_feature_specials[i] = other_feature_specials[i];
//        }
//        _other_feature_specials[_other_feature_specials.length - 1] = MathUtils.calculate31(feature);
//        this.setOther_feature_specials(_other_feature_specials);
//        _other_feature_specials[0] = MathUtils.calculate31(_feature_specials[0]);
//    }

    /**
     * @description: 均值采样项
     **/
//    default void average_feature(float[] feature, int index) {
//        float[][] feature_specials = this.getFeature_specials();
//        int[] weight = this.getWeight();
//        float[] other_feature_specials = this.getOther_feature_specials();
//
//        this.getFeature_specials()[index] = MathUtils.calculateColumnAverages(feature_specials[index], weight[index], feature);
//        weight[index]++;
//        other_feature_specials[index] = MathUtils.calculate31(feature_specials[index]);
//
//        feature_specials[0] = MathUtils.calculateColumnAverages(feature_specials[0], weight[0], feature);
//        weight[0]++;
//        other_feature_specials[0] = MathUtils.calculate31(feature_specials[0]);
//    }

    /**
     * @description: 覆盖采样项
     **/
//    default void replace_feature(float[] feature, int index) {
//        this.getCounter()[index] = 0;
//        this.getCreates()[index] = DateUtils.getFormatDate(new Date(), "yyMMdd");
//
//        float[][] feature_specials = this.getFeature_specials();
//        float[] other_feature_specials = this.getOther_feature_specials();
//
//        feature_specials[index] = feature;
//        other_feature_specials[index] = MathUtils.calculate31(feature);
//
//        feature_specials[0] = MathUtils.calculateColumnAverages(feature_specials[0], this.getCounter()[0], feature);
//        this.getCounter()[0]++;
//        other_feature_specials[0] = MathUtils.calculate31(feature_specials[0]);
//    }

    /**
     * @description: 首次初始化 特征 开方值
     **/
//    default T init_other_feature_specials() {
//        float[][] feature_specials = this.getFeature_specials();
//        if (feature_specials != null && feature_specials.length > 0) {
//            float[] other_feature_specials = new float[feature_specials.length];
//            for (int i = 0; i < feature_specials.length; i++) {
//                other_feature_specials[i] = MathUtils.calculate31(feature_specials[i]);
//            }
//            this.setOther_feature_specials(other_feature_specials);
//        }
//        return (T) this;
//    }

    String getLabel_name();

    T setLabel_name(String label_name);

    String getNick_name();

    T setNick_name(String nick_name);

    int[] getWeight();

    T setWeight(int[] weight);

    String[] getFeature_specials();

    T setFeature_specials(String[] feature_specials);

    int[] getCounter();

    T setCounter(int[] counter);

    String[] getCreates();

    T setCreates(String[] creates);

    Map<Integer, Map<Integer, List<AIValue>>> getSelf_values();

    T setSelf_values(Map<Integer, Map<Integer, List<AIValue>>> self_values);

    Map<Integer, Float> getOther_values();

    T setOther_values(Map<Integer, Float> other_values);
}
