package com.jhscale.common.model.device.ai_feature;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device._inner.AIValue;

import java.util.List;
import java.util.Map;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @title: DAIFeatureV1
 * @projectName common
 * @description: TODO
 * @date 2023/7/233:47
 */
@DataClass(mark = AIF, ask = true, serial = 8)
public class DAIFeatureV1<T extends DAIFeatureV1> implements DAIFeature<T> {

    // @ApiModelProperty(value = "模型编号", name = "name")
    @PublicField(index = 1, type = TXT)
    private String label_name;

    // @ApiModelProperty(value = "模型名称", name = "nickName")
    @PublicField(index = 2, type = TXT)
    private String nick_name;

    // @ApiModelProperty(value = "参数值权重", name = "weight")
    @PublicField(index = 2, type = M0)
    private int[] weight;

    // @ApiModelProperty(value = "特征值 0|1:val:label", name = "feature_specials")
    @PublicField(index = 3, type = M1)
    private String[] feature_specials;

    // @ApiModelProperty(value = "使用次数", name = "counter")
    @PublicField(index = 4, type = M2)
    private int[] counter;

    // @ApiModelProperty(value = "创建年月日（yyMMdd）", name = "creates")
    @PublicField(index = 5, type = M3)
    private String[] creates;

    // @ApiModelProperty(value = "参照素材<类型，<序号,数据内容>>", name = "self_values")
    private Map<Integer, Map<Integer, List<AIValue>>> self_values;

    // @ApiModelProperty(value = "特征值特性", name = "other_value")
    private Map<Integer, Float> other_values;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        // 前置数据处理
        this.prepose();
        return new StringBuilder()
                .append(this.to_append(AIF))
                .append(this.to_append(this.label_name))
                .append(this.to_append(this.nick_name))
                .append(this.to_append(this.weight()))
                .append(this.to_append(this.specials()))
                .append(this.to_append(this.counter()))
                .append(this.to_append(this.creates()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setLabel_name(this.toString(all_fields, 0));
        this.setNick_name(this.toString(all_fields, 1));
        this.weight(this.toString(all_fields, 2));
        this.feature_specials(this.toString(all_fields, 3));
        this.counter(this.toString(all_fields, 4));
        this.creates(this.toString(all_fields, 5));
        this.arrayToMap();
        return (T) this;
    }

    public String getLabel_name() {
        return label_name;
    }

    public T setLabel_name(String label_name) {
        this.label_name = label_name;
        return (T) this;
    }

    public String getNick_name() {
        return nick_name;
    }

    public T setNick_name(String nick_name) {
        this.nick_name = nick_name;
        return (T) this;
    }

    public int[] getWeight() {
        return weight;
    }

    public T setWeight(int[] weight) {
        this.weight = weight;
        return (T) this;
    }

    public String[] getFeature_specials() {
        return feature_specials;
    }

    public T setFeature_specials(String[] feature_specials) {
        this.feature_specials = feature_specials;
        return (T) this;
    }

    public int[] getCounter() {
        return counter;
    }

    public T setCounter(int[] counter) {
        this.counter = counter;
        return (T) this;
    }

    public String[] getCreates() {
        return creates;
    }

    public T setCreates(String[] creates) {
        this.creates = creates;
        return (T) this;
    }

    public Map<Integer, Map<Integer, List<AIValue>>> getSelf_values() {
        return self_values;
    }

    public T setSelf_values(Map<Integer, Map<Integer, List<AIValue>>> self_values) {
        this.self_values = self_values;
        return (T) this;
    }

    public Map<Integer, Float> getOther_values() {
        return other_values;
    }

    public T setOther_values(Map<Integer, Float> other_values) {
        this.other_values = other_values;
        return (T) this;
    }
}
