package com.jhscale.common.model.device.barcode_format;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DBarcode
 * @projectName common
 * @description: 条码格式
 * @date 2022/12/3013:50
 */
@DataClass(mark = BAR, ignorePublicField = DEFAULT_IGNORE_PUBLIC_FIELD_CODE_LAST)
public class DBarcodeFormatV1<T extends DBarcodeFormatV1> extends DData<T> implements DBarcodeFormat<T> {

    // @ApiModelProperty(value = "条码描述名", name = "name")
    @PublicField(index = 2, type = TXT)
    private String name;

    // @ApiModelProperty(value = "条码格式", name = "format")
    @PublicField(index = 3, type = INT)
    private Integer format;

    // @ApiModelProperty(value = "条码参数", name = "check")
    @PublicField(index = 4, type = INT)
    private Integer check;

    // @ApiModelProperty(value = "常数字1", name = "nConst1")
    @PublicField(index = 5, type = INT)
    private Integer nConst1;

    // @ApiModelProperty(value = "常数字2", name = "nConst2")
    @PublicField(index = 6, type = INT)
    private Integer nConst2;

    // @ApiModelProperty(value = "条码数字编码", name = "dis")
    @PublicField(index = 7, type = TXT_M1)
    private String dis;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(BAR))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getName()))
                .append(this.to_append(this.getFormat()))
                .append(this.to_append(this.getCheck()))
                .append(this.to_append(this.getnConst1()))
                .append(this.to_append(this.getnConst2()))
                .append(this.to_append(this.getDis()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setName(this.toText(all_fields, 1))
                .setFormat(this.toInteger(all_fields, 2))
                .setCheck(this.toInteger(all_fields, 3))
                .setnConst1(this.toInteger(all_fields, 4))
                .setnConst2(this.toInteger(all_fields, 5))
                .setDis(this.toString(all_fields, 6));
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    @Override
    public Integer getFormat() {
        return format;
    }

    public T setFormat(Integer format) {
        this.format = format;
        return (T) this;
    }

    @Override
    public Integer getCheck() {
        return check;
    }

    public T setCheck(Integer check) {
        this.check = check;
        return (T) this;
    }

    @Override
    public Integer getnConst1() {
        return nConst1;
    }

    public T setnConst1(Integer nConst1) {
        this.nConst1 = nConst1;
        return (T) this;
    }

    @Override
    public Integer getnConst2() {
        return nConst2;
    }

    public T setnConst2(Integer nConst2) {
        this.nConst2 = nConst2;
        return (T) this;
    }

    @Override
    public String getDis() {
        return dis;
    }

    public T setDis(String dis) {
        this.dis = dis;
        return (T) this;
    }
}
