package com.jhscale.common.model.device.barcode_format;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;
import com.jhscale.common.model.device.barcode_format.module.DBarV2;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DBarcode
 * @projectName common
 * @description: 条码格式2
 * @date 2022/12/3013:50
 */
@DataClass(mark = BAR, ignorePublicField = DEFAULT_IGNORE_PUBLIC_FIELD_CODE_LAST)
public class DBarcodeFormatV2<T extends DBarcodeFormatV2> extends DData<T> implements DBarcodeFormat<T> {

    // @ApiModelProperty(value = "分隔符", name = "format")
    @PublicField(index = 3, type = TXT, defaultVal = " ")
    private String split;

    @PublicField(index = 4, type = LST1_M1,
            list_type = FML, list_class = DBarV2.class)
    private List<DBarV2> bars;

    /****************************************************************/

    public String split() {
        return StringUtils.isNotBlank(this.split) ? this.split.substring(0, 1) : " ";
    }

    /**
     * @description: 添加条码格式
     **/
    public T add(DBarV2... bars) {
        if (bars != null && bars.length > 0) {
            return this.add(Arrays.asList(bars));
        }
        return (T) this;
    }

    /**
     * @description: 添加条码格式
     **/
    public T add(List<DBarV2> bars) {
        if (bars != null && !bars.isEmpty()) {
            if (this.bars == null) this.bars = new ArrayList<>();
            this.bars.addAll(bars);
        }
        return (T) this;
    }

    /****************************************************************/

    public String getSplit() {
        return split;
    }

    public T setSplit(String split) {
        this.split = split;
        return (T) this;
    }

    public List<DBarV2> getBars() {
        return bars;
    }

    public T setBars(List<DBarV2> bars) {
        this.bars = bars;
        return (T) this;
    }

    /**
     * @description: 类型
     **/
    @Override
    public Integer getFormat() {
        return 0;
    }

    /**
     * @description: 类型参数
     **/
    @Override
    public Integer getCheck() {
        return 0;
    }

    /**
     * @description: 常量1
     **/
    @Override
    public Integer getnConst1() {
        return 0;
    }

    /**
     * @description: 常量2
     **/
    @Override
    public Integer getnConst2() {
        return 0;
    }

    /**
     * @description: 内容细节
     **/
    @Override
    public String getDis() {
        return "";
    }
}
