package com.jhscale.common.model.device.barcode_format.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;

import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.INT;

/**
 * @author lie_w
 * @title: DBar
 * @projectName common
 * @description: TODO
 * @date 2023/5/3014:30
 */
@ApiModel("V2条码内容格式")
@DataClass
public class DBarV2 extends FieldModel {

    // @ApiModelProperty(value = "成员编号", name = "no")
    // 0-	序号
    // 1-	日期
    // 2-	时间
    // 3-	净重
    // 4-	毛重
    // 5-	皮重
    // 6-	货号
    // 7-	名称
    // 8-	常文本  scontent 常文本序号
    // 10-	Fid
    @PublicField(index = 1, type = INT)
    private Integer sno;

    // @ApiModelProperty(value = "成员内容", name = "scontent")
    @PublicField(index = 2, type = INT, defaultVal = "0")
    private Integer scontent;

    /****************************************************************/

    public int sno() {
        return Objects.nonNull(this.sno) ? this.sno : 0;
    }

    public int scontent() {
        return Objects.nonNull(this.scontent) ? this.scontent : 0;
    }

    /****************************************************************/

    public Integer getSno() {
        return sno;
    }

    public DBarV2 setSno(Integer sno) {
        this.sno = sno;
        return this;
    }

    public Integer getScontent() {
        return scontent;
    }

    public DBarV2 setScontent(Integer scontent) {
        this.scontent = scontent;
        return this;
    }
}
