package com.jhscale.common.model.device.bitmap;

import com.jhscale.common.model.inter.DataJSONModel;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: DBarcode
 * @projectName common
 * @description: 位图
 * @date 2022/12/3013:50
 */
public interface DBitMap<T extends DBitMap> extends DataJSONModel<T> {

    String getBmp();

    /**
     * @description: BitMap Hex
     **/
    default String bitMapHex() {
        if (StringUtils.isNotBlank(this.getBmp())) {
            byte[] bytes = this.getBmp().getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                int value = bytes[i];
                if (value <= 0x49)
                    bytes[i] = (byte) (value - 0x10);
                else
                    bytes[i] = (byte) (value - 9);
            }
            return new String(bytes);
        }
        return "";
    }
}
