package com.jhscale.common.model.device.bitmap;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DBarcode
 * @projectName common
 * @description: 位图
 * @date 2022/12/3013:50
 */
@DataClass(mark = BMP, ignorePublicField = DEFAULT_IGNORE_PUBLIC_FIELD_CODE_LAST)
public class DBitMapV1<T extends DBitMapV1> extends DData<T> implements DBitMap<T> {

    // @ApiModelProperty(value = "BMP", name = "bmp")
    @PublicField(index = 2, type = TXT_M1)
    private String bmp;

    // @ApiModelProperty(value = "名称", name = "name")
    @PublicField(index = 3, type = TXT)
    private String name;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(BMP))
                .append(this.to_append(this.no()))
                .append(this.to_append(this.getBmp()))
                .append(this.to_append_text(this.getName()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setBmp(this.toString(all_fields, 1))
                .setName(this.toText(all_fields, 2));
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public String getBmp() {
        return bmp;
    }

    public T setBmp(String bmp) {
        this.bmp = bmp;
        return (T) this;
    }
}
