package com.jhscale.common.model.device.category;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;
import com.jhscale.common.model.device.plu.module.DPrintV2;

import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DCategoryV1
 * @projectName common
 * @description: 分类（组）
 * @date 2022/10/910:42
 */
@DataClass(mark = CLS)
public class DCategoryV1<T extends DCategoryV1> extends DData<T> implements DCategory<T> {

    // 分类编号默认从9开始

    // @ApiModelProperty(value = "分类（组）名称", name = "name")
    @PublicField(index = 2, type = TXT)
    private String name;

    // @ApiModelProperty(value = "父分类（组）名称 默认：9", name = "dept")
    @PublicField(index = 3, type = INT)
    private Integer dept;

    // @ApiModelProperty(value = "打印信息", name = "print")
    @PublicField(index = 4, type = FML_M1, field_class = DPrintV2.class, field_length = 6)
    private DPrintV2 print;

    // @ApiModelProperty(value = "排列序号", name = "serial")
    // @PublicField(index = 5, type = INT)
    // private Integer serial;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(CLS))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getName()))
                .append(this.to_append(this.getDept()))
                .append(this.to_append(this.print().getType1()))
                .append(this.to_append(this.print().getBarcode1()))
                .append(this.to_append(this.print().getSign1()))
                .append(this.to_append(this.print().getType2()))
                .append(this.to_append(this.print().getBarcode2()))
                .append(this.to_append(this.print().getSign2()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @param
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setName(this.toText(all_fields, 1))
                .setDept(this.toInteger(all_fields, 2))
                .setPrint(new DPrintV2<>()
                        .setType1(this.toInteger(all_fields, 3))
                        .setBarcode1(this.toInteger(all_fields, 4))
                        .setSign1(this.toInteger(all_fields, +5))
                        .setType2(this.toInteger(all_fields, +6))
                        .setBarcode2(this.toInteger(all_fields, 7))
                        .setSign2(this.toInteger(all_fields, 8)));
        return (T) this;
    }

    public DPrintV2 print() {
        return Objects.nonNull(this.print) ? this.print : new DPrintV2();
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public Integer getDept() {
        return dept;
    }

    public T setDept(Integer dept) {
        this.dept = dept;
        return (T) this;
    }

    public DPrintV2 getPrint() {
        return print;
    }

    public T setPrint(DPrintV2 print) {
        this.print = print;
        return (T) this;
    }

    // public Integer getSerial() {
    //     return serial;
    // }

    // public T setSerial(Integer serial) {
    //     this.serial = serial;
    //     return (T) this;
    // }
}
