package com.jhscale.common.model.device.data_parameter;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DDataParameter
 * @projectName common
 * @description: 数据参数(暂不做服务器参数)
 * @date 2022/12/3013:45
 */
@DataClass(mark = TMS, ignorePublicField = DEFAULT_IGNORE_PUBLIC_FIELD_CODE_LAST)
public class DDataParameterV1<T extends DDataParameterV1> extends DData<T> implements DDataParameter<T> {

    // @ApiModelProperty(value = "数据参数数值", name = "value")
    @PublicField(index = 2, type = INT)
    private Integer value;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(TMS))
                .append(this.to_append(this.no()))
                .append(this.to_append(this.getValue()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setValue(this.toInteger(all_fields, 1));
        return (T) this;
    }

    public Integer getValue() {
        return value;
    }

    public T setValue(Integer value) {
        this.value = value;
        return (T) this;
    }
}
