
package com.jhscale.common.model.device.font;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DBarcode
 * @projectName common
 * @description: 位图
 * @date 2022/12/3013:50
 */
@DataClass(mark = FNT, ignorePublicField = DEFAULT_IGNORE_PUBLIC_FIELD_CODE_LAST)
public class DFontV1<T extends DFontV1> implements DFont<T> {

    // @ApiModelProperty(value = "FNT", name = "fnt")
    @PublicField(index = 2, type = TXT_M1)
    private String fnt;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return this.Public_Package_No_Reflex()
                .append(this.to_append(FNT))
                .append(this.to_append(this.getFnt()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setFnt(this.toString(all_fields, 0));
        return (T) this;
    }

    @Override
    public String getFnt() {
        return fnt;
    }

    public DFontV1<T> setFnt(String fnt) {
        this.fnt = fnt;
        return this;
    }
}
