package com.jhscale.common.model.device.info;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INA;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INF;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INI;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INM;
import com.jhscale.common.model.inter.DataJSONModel;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @title: DDeviceInfo
 * @projectName common
 * @description: TODO
 * @date 2023/1/1613:12
 */
public interface DDeviceInfo<T extends DDeviceInfo> extends DataJSONModel<T> {

    /**
     * @description: 公开协议 组包
     **/
    @Override
    default String Public_Package() {
        StringBuffer buffer = new StringBuffer();
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        if (annotation != null) {
            buffer.append(this.Public_Package(annotation.separator()))
                    .append(annotation.separator());
        }
        return buffer.toString();
    }

    /**
     * @param content
     * @description: 公开协议 拆包
     */
    @Override
    default T Public_UnPackage(String content) {
        if (StringUtils.isNotBlank(content)) {
            DataClass annotation = this.getClass().getAnnotation(DataClass.class);
            if (annotation != null) {
                String[] contents = content.split(annotation.separator());
                for (String p_content : contents) {
                    if (StringUtils.isNotBlank(p_content)) {
                        String[] pf_contents = p_content.split(annotation.line());
                        String[] f_contents = Arrays.copyOfRange(pf_contents, 1, pf_contents.length);
                        switch (pf_contents[0]) {
                            case INF_INA:
                                this.setIna(new DDeviceInfo_INA<>().Public_UnPackage_This(f_contents));
                                break;
                            case INF_INM:
                                this.setInm(new DDeviceInfo_INM<>().Public_UnPackage_This(f_contents));
                                break;
                            case INF_INF:
                                this.setInf(new DDeviceInfo_INF<>().Public_UnPackage_This(f_contents));
                                break;
                            case INF_INI:
                                this.setIni(new DDeviceInfo_INI<>().Public_UnPackage_This(f_contents));
                                break;
                        }
                    }
                }
            }
        }
        return (T) this;
    }

    /**
     * @description: 设备INA 信息
     **/
    T setIna(DDeviceInfo_INA ina);

    /**
     * @description: 设备INM 信息
     **/
    T setInm(DDeviceInfo_INM inm);

    /**
     * @description: 设备INF 信息
     **/
    T setInf(DDeviceInfo_INF inf);

    /**
     * @description: 设备AI信息
     **/
    T setIni(DDeviceInfo_INI ini);
}
