package com.jhscale.common.model.device.info;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INA;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INF;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INI;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INM;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DPrintFormat
 * @projectName common
 * @description: 设备信息
 * @date 2022/12/3013:53
 */
@DataClass(separator = PUBLIC_LINE_SPLIT, line = PUBLIC_FIELD_SPLIT)
public class DDeviceInfoV1<T extends DDeviceInfoV1> implements DDeviceInfo<T> {

    // @ApiModelProperty(value = "ina 设备信息", name = "ina")
    @PublicField(index = 1, type = FML, field_class = DDeviceInfo_INA.class)
    private DDeviceInfo_INA ina;

    // @ApiModelProperty(value = "inm 设备信息", name = "inm")
    @PublicField(index = 2, type = FML, field_class = DDeviceInfo_INM.class)
    private DDeviceInfo_INM inm;

    // @ApiModelProperty(value = "inf 设备信息", name = "inf")
    @PublicField(index = 3, type = FML, field_class = DDeviceInfo_INF.class)
    private DDeviceInfo_INF inf;

    @PublicField(index = 4, type = FML, field_class = DDeviceInfo_INI.class)
    private DDeviceInfo_INI ini;

    public DDeviceInfo_INA getIna() {
        return ina;
    }

    public T setIna(DDeviceInfo_INA ina) {
        this.ina = ina;
        return (T) this;
    }

    public DDeviceInfo_INM getInm() {
        return inm;
    }

    public T setInm(DDeviceInfo_INM inm) {
        this.inm = inm;
        return (T) this;
    }

    public DDeviceInfo_INF getInf() {
        return inf;
    }

    public T setInf(DDeviceInfo_INF inf) {
        this.inf = inf;
        return (T) this;
    }

    public DDeviceInfo_INI getIni() {
        return ini;
    }

    public T setIni(DDeviceInfo_INI ini) {
        this.ini = ini;
        return (T) this;
    }
}
