package com.jhscale.common.model.device.info;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import static com.jhscale.common.model.device.DConstant.M0;
import static com.jhscale.common.model.device.DConstant.MAC;

/**
 * @author wang lie
 * @title: MAC
 * @projectName common
 * @description: TODO
 * @date 2023/1/2010:25
 */
@DataClass(mark = MAC)
public class DMAC<T extends DMAC> implements DataJSONModel<T> {

    // @ApiModelProperty(value = "设备MAC", name = "mac")
    @PublicField(index = 1, type = M0)
    private String mac;

    /**
     * @param serial
     * @description: 默认组装方法1
     */
    @Override
    public String package_method(int serial) {
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        StringBuffer buffer = new StringBuffer();
        switch (serial) {
            case 0:
                String mac = StringUtils.isBlank(this.mac) || !ByteUtils.isHex(this.mac) ?
                        "000000" :
                        (this.mac.length() % 2 != 0 ? ("0" + this.mac) : this.mac);
                int len = mac.length() / 2;
                for (int i = 0; i < len; i++) {
                    buffer.append(Integer.parseInt(mac.substring(i * 2, i * 2 + 2), 16))
                            .append(i == len - 1 ? "" : annotation.separator());
                }
                break;
        }
        return buffer.toString();
    }

    /**
     * @param contents
     * @param serial
     * @description: 默认拆解方法1
     */
    @Override
    public PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        switch (serial) {
            case 0:
                unPackage = this.contents_copyOfRange(contents, contents.length);
                String[] mac_contents = ((PublicUnPackageArray) unPackage).getContents();
                String mac = "";
                for (String mac_content : mac_contents) {
                    mac += ByteUtils.int2Hex(Integer.parseInt(mac_content));
                }
                this.mac = mac;
                break;
        }
        return unPackage;
    }

    public String getMac() {
        return mac;
    }

    public DMAC<T> setMac(String mac) {
        this.mac = mac;
        return this;
    }
}
