package com.jhscale.common.model.device.info;

import com.jhscale.common.em.PayBizType;
import com.jhscale.common.em.PayWay;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.StringUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: UPPayment
 * @projectName ysscale_core
 * @description: 支付信息
 * @date 2021/5/710:09
 */
public class DPayment extends JSONModel {

    // 渠道
    private String channel;

    // 业务类型
    private String bizType;

    // 客户编号
    private String cstNo;

    // 渠道信息
    private String channelInfo;

    // 渠道支持
    private String support;

    public DPayment() {
    }

    public DPayment(String channel, String bizType, String cstNo, String channelInfo, String support) {
        this.channel = channel;
        this.bizType = bizType;
        this.cstNo = cstNo;
        this.channelInfo = channelInfo;
        this.support = support;
    }

    public String info() {
        PayWay payWay = PayWay.orderPay(this.channel);
        if (payWay != null) {
            String payment = String.format("%s%s:%s",
                    payWay.getDescription(),
                    (PayBizType.被扫.equals(PayBizType.bizType(this.bizType)) ? "*" : ""),
                    (StringUtils.isNotBlank(this.cstNo) ?
                            (this.cstNo.length() >= 6 ? StringUtil.privacyWithlength(this.cstNo, 3, 3) : this.cstNo) : "")
            );
            return payment;
        }
        return null;
    }

    public String getChannel() {
        return channel;
    }

    public DPayment setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public String getBizType() {
        return bizType;
    }

    public DPayment setBizType(String bizType) {
        this.bizType = bizType;
        return this;
    }

    public String getCstNo() {
        return cstNo;
    }

    public DPayment setCstNo(String cstNo) {
        this.cstNo = cstNo;
        return this;
    }

    public String getChannelInfo() {
        return channelInfo;
    }

    public DPayment setChannelInfo(String channelInfo) {
        this.channelInfo = channelInfo;
        return this;
    }

    public String getSupport() {
        return support;
    }

    public DPayment setSupport(String support) {
        this.support = support;
        return this;
    }
}
