package com.jhscale.common.model.device.info;

import com.jhscale.common.em.ServerDeviceConfig;
import com.jhscale.common.em.SwitchState;
import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.JSONUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author lie_w
 * @title: DServerConfig
 * @projectName common
 * @description: TODO
 * @date 2023/3/248:32
 */
public class DServerConfig implements GJSONModel {

    // @ApiModelProperty(notes = "配置信息", name = "configs")
    private Map<String, String> configs;

    public DServerConfig() {
    }

    public DServerConfig(Map<String, String> configs) {
        this.configs = configs;
    }

    /**
     * @description: 添加ServerConfig
     **/
    public DServerConfig addConfigs(DServerConfig serverConfig) {
        if (serverConfig == null) return this;
        this.addConfigs(serverConfig.getConfigs());
        return this;
    }

    /**
     * @description: 添加配置
     **/
    public DServerConfig addConfigs(Map<String, String> configs) {
        if (configs == null || configs.isEmpty()) return null;
        if (this.configs == null) this.configs = new HashMap<>();
        this.configs.putAll(configs);
        return this;
    }

    public DServerConfig addConfigStr(String key, String str) {
        if (this.configs == null) this.configs = new HashMap<>();
        if (StringUtils.isNotBlank(key) && StringUtils.isNotBlank(str))
            this.configs.put(key, str);
        return this;
    }

    public DServerConfig addConfigObj(String key, Object obj) {
        if (StringUtils.isNotBlank(key) && Objects.nonNull(obj)) {
            return this.addConfigStr(key, obj.toString());
        }
        return this;
    }

    public DServerConfig addConfigModel(String key, JSONModel model) {
        if (StringUtils.isNotBlank(key) && Objects.nonNull(model)) {
            return this.addConfigStr(key, model.toJSON());
        }
        return this;
    }

    /**
     * @description: 文本参数值
     **/
    public String strGet(String type, String def) {
        if (this.configs != null && !this.configs.isEmpty()) {
            String str = this.configs.get(type);
            return StringUtils.isNotBlank(str) ? str : def;
        }
        return def;
    }

    public String strGet(ServerDeviceConfig config) {
        return this.strGet(config.getType(), config.getDefVal());
    }

    /**
     * @description: 开关参数值
     **/
    public SwitchState switchGet(String type, String def) {
        try {
            return SwitchState.switchState(this.strGet(type, def));
        } catch (Exception e) {
            return SwitchState.switchState(def);
        }
    }

    public SwitchState switchGet(String type, SwitchState def) {
        try {
            return SwitchState.switchState(this.strGet(type, def.getEnable()));
        } catch (Exception e) {
            return def;
        }
    }

    public SwitchState switchGet(ServerDeviceConfig config) {
        try {
            return this.switchGet(config.getType(), config.getDefVal());
        } catch (Exception e) {
            return SwitchState.switchState(config.getDefVal());
        }
    }

    /**
     * @description: 数据参数值
     **/
    public int intGet(String type, String def) {
        try {
            return Integer.parseInt(this.strGet(type, def));
        } catch (Exception e) {
            try {
                return Integer.parseInt(def);
            } catch (Exception e1) {
                return 0;
            }
        }
    }

    public int intGet(String type, int def) {
        return this.intGet(type, String.valueOf(def));
    }

    public int intGet(ServerDeviceConfig config) {
        return this.intGet(config.getType(), config.getDefVal());
    }

    /**
     * @description: 数据参数值
     **/
    public long longGet(String type, String def) {
        try {
            return Long.parseLong(this.strGet(type, def));
        } catch (Exception e) {
            try {
                return Integer.parseInt(def);
            } catch (Exception e1) {
                return 0;
            }
        }
    }

    public long longGet(String type, long def) {
        return this.intGet(type, String.valueOf(def));
    }

    public long longGet(ServerDeviceConfig config) {
        return this.intGet(config.getType(), config.getDefVal());
    }

    /**
     * @description: 数据参数值
     **/
    public <T> T modelGet(String type, Class<T> clazz) {
        String str = this.strGet(type, "");
        return StringUtils.isNotBlank(str) ? JSONUtils.jsonToObject(str, clazz) : null;
    }

    public Map<String, String> getConfigs() {
        return configs;
    }

    public DServerConfig setConfigs(Map<String, String> configs) {
        this.configs = configs;
        return this;
    }
}
