package com.jhscale.common.model.device.info;

import com.jhscale.common.em.ServerDeviceConfig;
import com.jhscale.common.model.inter.GJSONModel;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: DServerInfo
 * @projectName common
 * @description: TODO
 * @date 2023/3/240:10
 */
public class DServerInfo implements GJSONModel {

    // @ApiModelProperty(notes = "云服务登陆状态", name = "cloud")
    private boolean cloud;

    // @ApiModelProperty(notes = "店铺信息", name = "bversion")
    private DInfo store;

    // @ApiModelProperty(notes = "市场信息", name = "storeSid")
    private DInfo market;

    // @ApiModelProperty(notes = "进销存信息", name = "storeName")
    private DInfo erp;

    // @ApiModelProperty(notes = "等级信息", name = "storeSid")
    private DInfo level;

    // @ApiModelProperty(notes = "聚合支付信息", name = "payments")
    private List<DPayment> payments;

    // @ApiModelProperty(notes = "服务器配置参数", name = "config")
    private DServerConfig config;

    // @ApiModelProperty(notes = "设备信息", name = "nickName")
    private DInfo device;

    public String device_info() {
        return Objects.nonNull(this.device) ? ("D* " + this.device.info()) : "";
    }

    public String store_info() {
        return Objects.nonNull(this.store) ? ("S* " + this.store.info()) : "";
    }

    public String store_all_info() {
        String info = this.store_info() + "/" + this.level_info();
        if (info.startsWith("/")) info = info.substring(1, info.length());
        if (info.endsWith("/")) info = info.substring(0, info.length() - 1);
        return info;
    }

    public String market_info() {
        return Objects.nonNull(this.market) && StringUtils.isNotBlank(this.market.getNo()) ? ("M* " + this.market.info()) : "";
    }

    public String erp_info() {
        return Objects.nonNull(this.erp) && StringUtils.isNotBlank(this.erp.getNo()) ? ("E* " + this.erp.info()) : "";
    }

    public String level_info() {
        return Objects.nonNull(this.level) && StringUtils.isNotBlank(this.level.getNo()) ? ("L* " + this.level.info()) : "";
    }

    public List<String> payment() {
        List<String> strs = new ArrayList<>();
        if (this.config != null
                && this.config.switchGet(ServerDeviceConfig.云支付).isOpen()
                && this.payments != null && !this.payments.isEmpty()) {
            for (DPayment payment : payments) {
                String info = payment.info();
                if (StringUtils.isNotBlank(info)) {
                    strs.add(info);
                }
            }
        }
        return strs;
    }

    public boolean isCloud() {
        return cloud;
    }

    public DServerInfo setCloud(boolean cloud) {
        this.cloud = cloud;
        return this;
    }

    public DInfo getStore() {
        return store;
    }

    public DServerInfo setStore(DInfo store) {
        this.store = store;
        return this;
    }

    public DInfo getMarket() {
        return market;
    }

    public DServerInfo setMarket(DInfo market) {
        this.market = market;
        return this;
    }

    public DInfo getErp() {
        return erp;
    }

    public DServerInfo setErp(DInfo erp) {
        this.erp = erp;
        return this;
    }

    public DInfo getLevel() {
        return level;
    }

    public DServerInfo setLevel(DInfo level) {
        this.level = level;
        return this;
    }

    public List<DPayment> getPayments() {
        return payments;
    }

    public DServerInfo setPayments(List<DPayment> payments) {
        this.payments = payments;
        return this;
    }

    public DServerConfig getConfig() {
        return config;
    }

    public DServerInfo setConfig(DServerConfig config) {
        this.config = config;
        return this;
    }

    public DInfo getDevice() {
        return device;
    }

    public DServerInfo setDevice(DInfo device) {
        this.device = device;
        return this;
    }
}
