package com.jhscale.common.model.device.info.inner;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @title: DDeviceInfo_INA
 * @projectName common
 * @description: TODO
 * @date 2023/1/1613:49
 */
@ApiModel("设备信息INA端")
@DataClass(mark = INF_INA, line = "")
public class DDeviceInfo_INA<T extends DDeviceInfo_INA> extends FieldModel<DDeviceInfo_INA> {

    @ApiModelProperty(value = "程序字符集", name = "encoding")
    @PublicField(index = 1, type = TXT)
    private String encoding;

    @ApiModelProperty(value = "字库字符集", name = "word_encoding")
    @PublicField(index = 2, type = TXT)
    private String word_encoding;

    @ApiModelProperty(value = "存储器空间", name = "rom")
    @PublicField(index = 3, type = INT)
    private Integer rom;

    @ApiModelProperty(value = "字库空间", name = "word_rom")
    @PublicField(index = 4, type = INT)
    private Integer word_rom;

    @ApiModelProperty(value = "1", name = "f1")
    @PublicField(index = 5, type = INT)
    private Integer f1;

    @ApiModelProperty(value = "2", name = "f2")
    @PublicField(index = 6, type = INT)
    private Integer f2;

    @ApiModelProperty(value = "3", name = "f3")
    @PublicField(index = 7, type = INT)
    private Integer f3;

    public String getEncoding() {
        return encoding;
    }

    public DDeviceInfo_INA<T> setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getWord_encoding() {
        return word_encoding;
    }

    public DDeviceInfo_INA<T> setWord_encoding(String word_encoding) {
        this.word_encoding = word_encoding;
        return this;
    }

    public Integer getRom() {
        return rom;
    }

    public DDeviceInfo_INA<T> setRom(Integer rom) {
        this.rom = rom;
        return this;
    }

    public Integer getWord_rom() {
        return word_rom;
    }

    public DDeviceInfo_INA<T> setWord_rom(Integer word_rom) {
        this.word_rom = word_rom;
        return this;
    }

    public Integer getF1() {
        return f1;
    }

    public DDeviceInfo_INA<T> setF1(Integer f1) {
        this.f1 = f1;
        return this;
    }

    public Integer getF2() {
        return f2;
    }

    public DDeviceInfo_INA<T> setF2(Integer f2) {
        this.f2 = f2;
        return this;
    }

    public Integer getF3() {
        return f3;
    }

    public DDeviceInfo_INA<T> setF3(Integer f3) {
        this.f3 = f3;
        return this;
    }
}
