package com.jhscale.common.model.device.info.inner;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @title: DDeviceInfo_INA
 * @projectName common
 * @description: TODO
 * @date 2023/1/1613:49
 */
@ApiModel("设备信息INF端")
@DataClass(mark = INF_INF, line = "")
public class DDeviceInfo_INF<T extends DDeviceInfo_INF> extends FieldModel<T> {

    @ApiModelProperty(value = "店名", name = "store_name")
    @PublicField(index = 1, type = TXT)
    private String store_name;

    @ApiModelProperty(value = "设备名", name = "device_name")
    @PublicField(index = 2, type = TXT)
    private String device_name;

    @ApiModelProperty(value = "设备号", name = "device_serial")
    @PublicField(index = 3, type = INT)
    private Integer device_serial;

    @ApiModelProperty(value = "设备版本", name = "device_version")
    @PublicField(index = 4, type = TXT)
    private String device_version;

    public String getStore_name() {
        return store_name;
    }

    public DDeviceInfo_INF<T> setStore_name(String store_name) {
        this.store_name = store_name;
        return this;
    }

    public String getDevice_name() {
        return device_name;
    }

    public DDeviceInfo_INF<T> setDevice_name(String device_name) {
        this.device_name = device_name;
        return this;
    }

    public Integer getDevice_serial() {
        return device_serial;
    }

    public DDeviceInfo_INF<T> setDevice_serial(Integer device_serial) {
        this.device_serial = device_serial;
        return this;
    }

    public String getDevice_version() {
        return device_version;
    }

    public DDeviceInfo_INF<T> setDevice_version(String device_version) {
        this.device_version = device_version;
        return this;
    }
}
