package com.jhscale.common.model.device.info.inner;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title DDeviceInfo_INI
 * @description
 * @create 2023/10/26 9:58
 */
@ApiModel("设备信息INi端")
@DataClass(mark = INF_INI, line = "")
public class DDeviceInfo_INI<T extends DDeviceInfo_INI> extends FieldModel<T> {

    @ApiModelProperty(value = "AI版本", name = "ai_open")
    @PublicField(index = 1, type = INT, defaultVal = "1")
    private Integer ai_open;

    @ApiModelProperty(value = "AI版本", name = "ai_server_open")
    @PublicField(index = 2, type = INT, defaultVal = "1")
    private Integer ai_server_open;

    @ApiModelProperty(value = "AI版本", name = "aiVersion")
    @PublicField(index = 3, type = TXT)
    private String aiVersion;

    public Integer getAi_open() {
        return ai_open;
    }

    public DDeviceInfo_INI<T> setAi_open(Integer ai_open) {
        this.ai_open = ai_open;
        return this;
    }

    public Integer getAi_server_open() {
        return ai_server_open;
    }

    public DDeviceInfo_INI<T> setAi_server_open(Integer ai_server_open) {
        this.ai_server_open = ai_server_open;
        return this;
    }

    public String getAiVersion() {
        return aiVersion;
    }

    public DDeviceInfo_INI<T> setAiVersion(String aiVersion) {
        this.aiVersion = aiVersion;
        return this;
    }
}
