package com.jhscale.common.model.device.info.inner;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @title: DDeviceInfo_INA
 * @projectName common
 * @description: TODO
 * @date 2023/1/1613:49
 */
@ApiModel("设备信息INM端")
@DataClass(mark = INF_INM, line = "")
public class DDeviceInfo_INM<T extends DDeviceInfo_INM> extends FieldModel<T> {

    @ApiModelProperty(value = "当前MAC(标识)", name = "sign")
    @PublicField(index = 1, type = TXT)
    private String sign;

    @ApiModelProperty(value = "唯一性MAC(标识)", name = "unique_sign")
    @PublicField(index = 2, type = TXT)
    private String unique_sign;

    @ApiModelProperty(value = "网络方式 0-唯一网络 1-Wifi 2-有线网", name = "lan")
    @PublicField(index = 3, type = INT)
    private Integer lan;

    public String getSign() {
        return sign;
    }

    public DDeviceInfo_INM<T> setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public String getUnique_sign() {
        return unique_sign;
    }

    public DDeviceInfo_INM<T> setUnique_sign(String unique_sign) {
        this.unique_sign = unique_sign;
        return this;
    }

    public Integer getLan() {
        return lan;
    }

    public DDeviceInfo_INM<T> setLan(Integer lan) {
        this.lan = lan;
        return this;
    }
}
