package com.jhscale.common.model.device.label_format;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DPrintFormat
 * @projectName common
 * @description: 标签格式
 * @date 2022/12/3013:53
 */
@DataClass(mark = LAT, ignorePublicField = DEFAULT_IGNORE_PUBLIC_FIELD_CODE_LAST)
public class DLabelFormatV1<T extends DLabelFormatV1> extends DData<T> implements DLabelFormat<T> {

    // @ApiModelProperty(value = "名称", name = "name")
    @PublicField(index = 2, type = TXT)
    private String name;

    // @ApiModelProperty(value = "LAT", name = "pf")
    @PublicField(index = 3, type = TXT_M1)
    private String pf;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(LAT))
                .append(this.to_append(this.no()))
                .append(this.to_append_text(this.getName()))
                .append(this.to_append(this.getPf()))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setNo(this.toInteger(all_fields, 0))
                .setName(this.toText(all_fields, 1))
                .setPf(this.toString(all_fields, 2));
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    @Override
    public String getPf() {
        return pf;
    }

    public T setPf(String pf) {
        this.pf = pf;
        return (T) this;
    }
}
