package com.jhscale.common.model.device.label_format;

import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.DData;
import com.jhscale.common.model.device.label_format.module.DLabelV2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DLabelFormatV2
 * @projectName common
 * @description: TODO
 * @date 2023/5/300:48
 */
public class DLabelFormatV2<T extends DLabelFormatV2> extends DData<T> implements DLabelFormat<T> {

    // @ApiModelProperty(value = "高度", name = "height")
    @PublicField(index = 2, type = INT)
    private Integer height;

    // @ApiModelProperty(value = "宽度", name = "weight")
    @PublicField(index = 3, type = INT)
    private Integer weight;

    @PublicField(index = 4, type = LST1_M1,
            list_type = FML, list_class = DLabelV2.class)
    private List<DLabelV2> labels;

    /****************************************************************/

    public int height() {
        return Objects.nonNull(this.height) ? this.height : 0;
    }

    public int weight() {
        return Objects.nonNull(this.weight) ? this.weight : 0;
    }

    /**
     * @description: 添加标签
     **/
    public T add(DLabelV2... labels) {
        if (labels != null && labels.length > 0) {
            return this.add(Arrays.asList(labels));
        }
        return (T) this;
    }

    /**
     * @description: 添加标签
     **/
    public T add(List<DLabelV2> labels) {
        if (labels != null && !labels.isEmpty()) {
            if (this.labels == null) this.labels = new ArrayList<>();
            this.labels.addAll(labels);
        }
        return (T) this;
    }

    /****************************************************************/

    /**
     * @description: 标签参数名称
     **/
    @Override
    public String getName() {
        return "";
    }

    /**
     * @description: 标签内容
     **/
    @Override
    public String getPf() {
        return "";
    }

    public Integer getHeight() {
        return height;
    }

    public T setHeight(Integer height) {
        this.height = height;
        return (T) this;
    }

    public Integer getWeight() {
        return weight;
    }

    public T setWeight(Integer weight) {
        this.weight = weight;
        return (T) this;
    }

    public List<DLabelV2> getLabels() {
        return labels;
    }

    public T setLabels(List<DLabelV2> labels) {
        this.labels = labels;
        return (T) this;
    }
}
