package com.jhscale.common.model.device.label_format.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;

import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.INT;

/**
 * @author lie_w
 * @title: DLabel
 * @projectName common
 * @description: TODO
 * @date 2023/5/300:52
 */
@ApiModel("V2子项标签信息")
@DataClass
public class DLabelV2 extends FieldModel {

    // @ApiModelProperty(value = "编号", name = "no")
    @PublicField(index = 1, type = INT)
    private Integer no;

    // @ApiModelProperty(value = "标志0", name = "sign0")
    @PublicField(index = 2, type = INT)
    private Integer sign0;

    // @ApiModelProperty(value = "标志1", name = "sign1")
    @PublicField(index = 3, type = INT)
    private Integer sign1;

    // @ApiModelProperty(value = "标志2", name = "sign2")
    @PublicField(index = 4, type = INT)
    private Integer sign2;

    // @ApiModelProperty(value = "起使坐标-横向", name = "x")
    @PublicField(index = 5, type = INT)
    private Integer x;

    // @ApiModelProperty(value = "起使坐标-纵向", name = "y")
    @PublicField(index = 6, type = INT)
    private Integer y;

    // @ApiModelProperty(value = "文本框-宽度", name = "width")
    @PublicField(index = 7, type = INT)
    private Integer width;

    // @ApiModelProperty(value = "文本框-高度", name = "height")
    @PublicField(index = 8, type = INT)
    private Integer height;

    // @ApiModelProperty(value = "字体放大-横向", name = "_x")
    @PublicField(index = 9, type = INT, defaultVal = "1")
    private Integer _x;

    // @ApiModelProperty(value = "字体放大-纵向", name = "_y")
    @PublicField(index = 10, type = INT, defaultVal = "1")
    private Integer _y;

    // @ApiModelProperty(value = "打印角度", name = "dir")
    @PublicField(index = 11, type = INT, defaultVal = "0")
    private Integer dir;

    // @ApiModelProperty(value = "附加格式 需要转换成二进制", name = "format")
    @PublicField(index = 12, type = INT, defaultVal = "0")
    private Integer format;

    // @ApiModelProperty(value = "对齐模式", name = "grid")
    @PublicField(index = 13, type = INT, defaultVal = "5")
    private Integer grid;

    // @ApiModelProperty(value = "字体编号", name = "font")
    @PublicField(index = 14, type = INT, defaultVal = "1")
    private Integer font;

    /****************************************************************/

    @Override
    public Integer no() {
        return Objects.nonNull(this.no) ? this.no : 0;
    }

    public int sign0() {
        return Objects.nonNull(this.sign0) ? this.sign0 : 0;
    }

    public int sign1() {
        return Objects.nonNull(this.sign1) ? this.sign1 : 0;
    }

    public int sign2() {
        return Objects.nonNull(this.sign2) ? this.sign2 : 0;
    }

    public int x() {
        return Objects.nonNull(this.x) ? this.x : 0;
    }

    public int y() {
        return Objects.nonNull(this.y) ? this.y : 0;
    }

    public int width() {
        return Objects.nonNull(this.width) ? this.width : 0;
    }

    public int height() {
        return Objects.nonNull(this.height) ? this.height : 0;
    }

    public Integer _x() {
        return Objects.nonNull(this._x) ? this._x : 1;
    }

    public int _y() {
        return Objects.nonNull(this._y) ? this._y : 1;
    }

    public int dir() {
        return Objects.nonNull(this.dir) ? this.dir : 0;
    }

    public int format() {
        return Objects.nonNull(this.format) ? this.format : 0;
    }

    public int grid() {
        return Objects.nonNull(this.grid) ? this.grid : 5;
    }

    public int font() {
        return Objects.nonNull(this.font) ? this.font : 1;
    }

    /****************************************************************/

    public Integer getNo() {
        return no;
    }

    public DLabelV2 setNo(Integer no) {
        this.no = no;
        return this;
    }

    public Integer getSign0() {
        return sign0;
    }

    public DLabelV2 setSign0(Integer sign0) {
        this.sign0 = sign0;
        return this;
    }

    public Integer getSign1() {
        return sign1;
    }

    public DLabelV2 setSign1(Integer sign1) {
        this.sign1 = sign1;
        return this;
    }

    public Integer getSign2() {
        return sign2;
    }

    public DLabelV2 setSign2(Integer sign2) {
        this.sign2 = sign2;
        return this;
    }

    public Integer getX() {
        return x;
    }

    public DLabelV2 setX(Integer x) {
        this.x = x;
        return this;
    }

    public Integer getY() {
        return y;
    }

    public DLabelV2 setY(Integer y) {
        this.y = y;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public DLabelV2 setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public DLabelV2 setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Integer get_x() {
        return _x;
    }

    public DLabelV2 set_x(Integer _x) {
        this._x = _x;
        return this;
    }

    public Integer get_y() {
        return _y;
    }

    public DLabelV2 set_y(Integer _y) {
        this._y = _y;
        return this;
    }

    public Integer getDir() {
        return dir;
    }

    public DLabelV2 setDir(Integer dir) {
        this.dir = dir;
        return this;
    }

    public Integer getFormat() {
        return format;
    }

    public DLabelV2 setFormat(Integer format) {
        this.format = format;
        return this;
    }

    public Integer getGrid() {
        return grid;
    }

    public DLabelV2 setGrid(Integer grid) {
        this.grid = grid;
        return this;
    }

    public Integer getFont() {
        return font;
    }

    public DLabelV2 setFont(Integer font) {
        this.font = font;
        return this;
    }
}
