package com.jhscale.common.model.device.log;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.device.log.module.DSource;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.BigDecimalUtils;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: DLOG
 * @projectName common
 * @description: 日志
 * @date 2022/9/1616:34
 */
public interface DLOG<T extends DLOG> extends DataJSONModel<T> {

    /**
     * @param serial
     * @description: 默认方法1
     */
    @Override
    default String package_method(int serial) {
        String result = "";
        try {
            switch (serial) {
                case 0:
                    result = this.getType().toString();
                    break;
                case 1:
                    DSource source = this.getSource();
                    if (source != null) result = source.getFid().toString();
                    break;
                case 2:
                    DataClass annotation = this.getClass().getAnnotation(DataClass.class);
                    result = BigDecimalUtils.bigDecimalToString(this.getTradeVal());
                    for (int i = 0; i < 16; i++) {
                        result += annotation.separator();
                    }
                    break;
            }
        } catch (Exception e) {
        }
        return result;
    }

    /**
     * @param contents
     * @param serial
     * @description: 默认拆解方法1
     */
    @Override
    default PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        try {
            switch (serial) {
                case 0:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                    this.setType(Integer.parseInt(((PublicUnPackageArray) unPackage).getContents()[0]));
                    break;
                case 1:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                    this.setSource(new DSource(Integer.parseInt(((PublicUnPackageArray) unPackage).getContents()[0])));
                    break;
                case 2:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 2);
                    this.setTradeVal(BigDecimalUtils.stringToBigDecimal(((PublicUnPackageArray) unPackage).getContents()[1]));
                    break;
            }
        } catch (Exception e) {
        }
        return unPackage;
    }

    /**
     * @description: 交易额
     **/
    BigDecimal getTradeVal();

    /**
     * @description: 设置交易信息
     **/
    T setTradeVal(BigDecimal tradeVal);

    /**
     * @description: 日志类型
     **/
    Integer getType();

    /**
     * @description: 设置日志
     **/
    T setType(Integer type);

    /**
     * @description: 退货信息
     **/
    DSource getSource();

    /**
     * @description: 添加退货信息
     **/
    T setSource(DSource source);
}
