package com.jhscale.common.model.device.log;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.annotation.*;
import com.jhscale.common.model.device.log.module.DGoods;
import com.jhscale.common.model.device.log.module.DSource;
import com.jhscale.common.utils.DateUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DLOGV1
 * @projectName common
 * @description: TODO
 * @date 2022/9/1616:35
 */
@DataClass(mark = REP, ask = true)
public class DLOGV1<T extends DLOGV1> implements DLOG<T> {

    // @ApiModelProperty(value = "日志编号", name = "fid")
    @ServerField(index = 1, length = 8, type = INT, must = true)
    @PublicField(index = 2, type = INT)
    private Integer fid;

    // @ApiModelProperty(value = "日志种类", name = "kind", example = "0：条码秤；1：POS秤；2：蓝牙吊秤；3：VPS PC Post")
    @ServerField(index = 2, length = 2, type = INT, must = true)
    private Integer kind;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    // @ApiModelProperty(value = "交易时间 毫秒数", name = "tradeTime")
    @ServerField(index = 3, type = TME, must = true)
    @PublicField(index = 1, type = TME, field_length = 6)
    private Date tradeTime;

    // @ApiModelProperty(value = "SID（日编号）", name = "sid")
    @ServerField(index = 4, length = 8, type = INT, must = true)
    @PublicField(index = 3, type = INT)
    private Integer sid;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "交易额", name = "tradeVal")
    @ServerField(index = 5, type = BDL, must = true)
    private BigDecimal tradeVal;

    // @ApiModelProperty(value = "日志类型", name = "type", example = "0:销售;1:退货;2:未确认;3:清除; 4:挂单;5:自动模式;6~9:预留; 10:入库;11:出库;12:盘库;13:订单;14:损耗;255:错误日志")
    @ServerField(index = 6, length = 4, type = INT, must = true)
    private Integer type;


    // @ApiModelProperty(value = "营业员编号", name = "saleMan")
    @ServerField(index = 7, length = 8, type = INT)
    @PublicField(index = 4, type = INT)
    private Integer saleMan;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "折舍金额", name = "roundingDiscount")
    @ServerField(index = 8, type = BDL)
    private BigDecimal roundingDiscount;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "税额", name = "tax")
    @ServerField(index = 9, type = BDL)
    private BigDecimal tax;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "成本", name = "cost")
    @ServerField(index = 10, type = BDL)
    private BigDecimal cost;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "现金", name = "cash")
    @ServerField(index = 11, type = BDL)
    private BigDecimal cash;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "卡付", name = "cardPay")
    @ServerField(index = 12, type = BDL)
    private BigDecimal cardPay;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "其他支付1", name = "otherPay1")
    @ServerField(index = 13, type = BDL)
    private BigDecimal otherPay1;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "其他支付2", name = "otherPay2")
    @ServerField(index = 14, type = BDL)
    private BigDecimal otherPay2;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "其他支付3", name = "otherPay3")
    @ServerField(index = 15, type = BDL)
    private BigDecimal otherPay3;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "服务费", name = "serviceCharge")
    @ServerField(index = 16, type = BDL)
    private BigDecimal serviceCharge;

    // @ApiModelProperty(value = "交易渠道", name = "payWay")
    @ServerField(index = 17, length = 4, type = INT)
    private Integer payWay;

    // @ApiModelProperty(value = "支付类型", name = "payType")
    @ServerField(index = 18, length = 4, type = INT)
    private Integer payType;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "聚合支付金额", name = "cloudPay")
    @ServerField(index = 19, type = BDL)
    private BigDecimal cloudPay;


    // @ApiModelProperty(value = "原始数据来源（退货使用）", name = "source")
    @ServerField(index = 20, type = FML, field_class = DSource.class)
    private DSource source;


    // @ApiModelProperty(value = "错误代码", name = "errCode")
    @ServerField(index = 21, type = TXT)
    private String errCode;

    // @ApiModelProperty(value = "错误文本1", name = "errMsg1")
    @ServerField(index = 22, type = TXT)
    private String errMsg1;

    // @ApiModelProperty(value = "错误文本2", name = "errMsg2")
    @ServerField(index = 23, type = TXT)
    private String errMsg2;

    // @ApiModelProperty(value = "错误文本3", name = "errMsg3")
    @ServerField(index = 24, type = TXT)
    private String errMsg3;

    // @ApiModelProperty(value = "错误文本4", name = "errMsg4")
    @ServerField(index = 25, type = TXT)
    private String errMsg4;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "吉卡云消费金额", name = "jkyPay")
    @ServerField(index = 26, type = BDL)
    private BigDecimal jkyPay;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "吉卡云赠送支付", name = "jkyGiftPay")
    @ServerField(index = 27, type = BDL)
    private BigDecimal jkyGiftPay;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "充值金额", name = "jkyRecharge")
    @ServerField(index = 28, type = BDL)
    private BigDecimal jkyRecharge;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "充值赠送", name = "jkyGiftRecharge")
    @ServerField(index = 29, type = BDL)
    private BigDecimal jkyGiftRecharge;

    // @ApiModelProperty(value = "日志明细", name = "goodsList")
    @ServerField(index = 30, type = LST, list_type = FML, list_class = DGoods.class)
    @PublicField(index = 5, type = LST1_M1,
            list_type = FML, list_class = DGoods.class)
    private List<DGoods> goodsList;

//    // @ApiModelProperty(value = "日志明细", name = "goodsList")
//    @ServerField(index = 31, type = MAP, map_key_type = TXT, map_val_type = TXT, map_val_class = String.class)
//    @PublicField(index = 6, type = MAP,
//            map_key_type = TXT, map_key_class = String.class, map_val_type = TXT, map_val_class = String.class,
//            map_prefix = RMS, map_separator = RMM, map_end = RME)
//    private Map<String, String> mapStr;

//    // @ApiModelProperty(value = "日志明细", name = "goodsList")
//    @ServerField(index = 32, type = MAP, map_key_type = INT, map_key_class = Integer.class, map_val_type = FML, map_val_class = DGoods.class)
//    @PublicField(index = 7, type = MAP,
//            map_key_type = INT, map_key_class = Integer.class, map_val_type = FML, map_val_class = DGoods.class,
//            map_prefix = RMS, map_separator = RMM, map_end = RME)
//    private Map<Integer, DGoods> goodsMap;

//    public Map<String, String> getMapStr() {
//        return mapStr;
//    }
//
//    public T setMapStr(Map<String, String> mapStr) {
//        this.mapStr = mapStr;
//        return (T) this;
//    }
//
//    public Map<Integer, DGoods> getGoodsMap() {
//        return goodsMap;
//    }
//
//    public T setGoodsMap(Map<Integer, DGoods> goodsMap) {
//        this.goodsMap = goodsMap;
//        return (T) this;
//    }


    /**
     * @description: 编号
     **/
    @Override
    public Integer no() {
        return this.fid;
    }

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        this.prepose();
        StringBuilder builder = new StringBuilder()
                .append(this.to_append(REP));

        String time_space = DateUtils.getFormatDate_YY_MM_DD_HH_MM_SS_Space(this.tradeTime);
        String[] split = time_space.split(" ");
        for (int index = 0; index < split.length; index++) {
            builder.append(this.to_append(Integer.parseInt(split[index])));
        }

        builder.append(this.to_append(this.fid))
                .append(this.to_append(this.sid))
                .append(this.to_append(this.saleMan))
                .append(PUBLIC_LINE_SPLIT);

        if (this.goodsList != null && !this.goodsList.isEmpty()) {
            for (int i = 0; i < this.goodsList.size(); i++) {
                DGoods goods = this.goodsList.get(i);
                builder.append(this.to_append(RES))
                        .append(this.to_append(i + 1))
                        .append(this.to_append(goods.getItemTotal()))
                        .append(this.to_append(goods.getNo()))
                        .append(this.to_append(goods.category()))
                        .append(this.to_append(goods.dept()))
                        .append(this.to_append(goods.cost()))
                        .append(this.to_append(goods.amount()))
                        .append(this.to_append(goods.getUnit()))
                        .append(this.to_append(this.type))
                        .append(this.to_append(goods.tax()))
                        .append(this.to_append(goods.getText1()))
                        .append(this.to_append(goods.getText2()))
                        .append(this.to_append(goods.getText3()))
                        .append(this.to_append(goods.getText4()))
                        .append(this.to_append(goods.price()));
                if (this.source != null) {
                    builder.append(this.to_append(this.source.getFid()));
                } else {
                    builder.append(this.to_append(0));
                }
                builder.append(this.to_append(goods.getName()))
                        .append(PUBLIC_LINE_SPLIT);
            }
            builder.append(this.to_append(REE))
                    .append(PUBLIC_LINE_SPLIT);
        }
        return builder;
    }

    public Integer getFid() {
        return fid;
    }

    public T setFid(Integer fid) {
        this.fid = fid;
        return (T) this;
    }

    public Integer getKind() {
        return kind;
    }

    public T setKind(Integer kind) {
        this.kind = kind;
        return (T) this;
    }

    public Date getTradeTime() {
        return tradeTime;
    }

    public T setTradeTime(Date tradeTime) {
        this.tradeTime = tradeTime;
        return (T) this;
    }

    public Integer getSid() {
        return sid;
    }

    public T setSid(Integer sid) {
        this.sid = sid;
        return (T) this;
    }

    public BigDecimal getTradeVal() {
        return tradeVal;
    }

    public T setTradeVal(BigDecimal tradeVal) {
        this.tradeVal = tradeVal;
        return (T) this;
    }

    public Integer getType() {
        return type;
    }

    public T setType(Integer type) {
        this.type = type;
        return (T) this;
    }

    public Integer getSaleMan() {
        return saleMan;
    }

    public T setSaleMan(Integer saleMan) {
        this.saleMan = saleMan;
        return (T) this;
    }

    public BigDecimal getRoundingDiscount() {
        return roundingDiscount;
    }

    public T setRoundingDiscount(BigDecimal roundingDiscount) {
        this.roundingDiscount = roundingDiscount;
        return (T) this;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public T setTax(BigDecimal tax) {
        this.tax = tax;
        return (T) this;
    }

    public BigDecimal getCost() {
        return cost;
    }

    public T setCost(BigDecimal cost) {
        this.cost = cost;
        return (T) this;
    }

    public BigDecimal getCash() {
        return cash;
    }

    public T setCash(BigDecimal cash) {
        this.cash = cash;
        return (T) this;
    }

    public BigDecimal getCardPay() {
        return cardPay;
    }

    public T setCardPay(BigDecimal cardPay) {
        this.cardPay = cardPay;
        return (T) this;
    }

    public BigDecimal getOtherPay1() {
        return otherPay1;
    }

    public T setOtherPay1(BigDecimal otherPay1) {
        this.otherPay1 = otherPay1;
        return (T) this;
    }

    public BigDecimal getOtherPay2() {
        return otherPay2;
    }

    public T setOtherPay2(BigDecimal otherPay2) {
        this.otherPay2 = otherPay2;
        return (T) this;
    }

    public BigDecimal getOtherPay3() {
        return otherPay3;
    }

    public T setOtherPay3(BigDecimal otherPay3) {
        this.otherPay3 = otherPay3;
        return (T) this;
    }

    public BigDecimal getServiceCharge() {
        return serviceCharge;
    }

    public T setServiceCharge(BigDecimal serviceCharge) {
        this.serviceCharge = serviceCharge;
        return (T) this;
    }

    public DSource getSource() {
        return source;
    }

    public T setSource(DSource source) {
        this.source = source;
        return (T) this;
    }

    public Integer getPayWay() {
        return payWay;
    }

    public T setPayWay(Integer payWay) {
        this.payWay = payWay;
        return (T) this;
    }

    public Integer getPayType() {
        return payType;
    }

    public T setPayType(Integer payType) {
        this.payType = payType;
        return (T) this;
    }

    public BigDecimal getCloudPay() {
        return cloudPay;
    }

    public T setCloudPay(BigDecimal cloudPay) {
        this.cloudPay = cloudPay;
        return (T) this;
    }

    public String getErrCode() {
        return errCode;
    }

    public T setErrCode(String errCode) {
        this.errCode = errCode;
        return (T) this;
    }

    public String getErrMsg1() {
        return errMsg1;
    }

    public T setErrMsg1(String errMsg1) {
        this.errMsg1 = errMsg1;
        return (T) this;
    }

    public String getErrMsg2() {
        return errMsg2;
    }

    public T setErrMsg2(String errMsg2) {
        this.errMsg2 = errMsg2;
        return (T) this;
    }

    public String getErrMsg3() {
        return errMsg3;
    }

    public T setErrMsg3(String errMsg3) {
        this.errMsg3 = errMsg3;
        return (T) this;
    }

    public String getErrMsg4() {
        return errMsg4;
    }

    public T setErrMsg4(String errMsg4) {
        this.errMsg4 = errMsg4;
        return (T) this;
    }

    public BigDecimal getJkyPay() {
        return jkyPay;
    }

    public T setJkyPay(BigDecimal jkyPay) {
        this.jkyPay = jkyPay;
        return (T) this;
    }

    public BigDecimal getJkyGiftPay() {
        return jkyGiftPay;
    }

    public T setJkyGiftPay(BigDecimal jkyGiftPay) {
        this.jkyGiftPay = jkyGiftPay;
        return (T) this;
    }

    public BigDecimal getJkyRecharge() {
        return jkyRecharge;
    }

    public T setJkyRecharge(BigDecimal jkyRecharge) {
        this.jkyRecharge = jkyRecharge;
        return (T) this;
    }

    public BigDecimal getJkyGiftRecharge() {
        return jkyGiftRecharge;
    }

    public T setJkyGiftRecharge(BigDecimal jkyGiftRecharge) {
        this.jkyGiftRecharge = jkyGiftRecharge;
        return (T) this;
    }

    public List<DGoods> getGoodsList() {
        return goodsList;
    }

    public T setGoodsList(List<DGoods> goodsList) {
        this.goodsList = goodsList;
        return (T) this;
    }

    /**
     * @description: 添加商品
     **/
    public T addGoods(DGoods... goods) {
        if (this.goodsList == null) this.goodsList = new ArrayList<>();
        if (goods != null && goods.length > 0) {
            this.goodsList.addAll(Arrays.asList(goods));
        }
        return (T) this;
    }
}
