package com.jhscale.common.model.device.log.inner;

import com.jhscale.common.model.simple.FieldModel;
import com.jhscale.common.ysscale.UnitEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: Goods
 * @projectName common
 * @description: TODO
 * @date 2022/9/1716:29
 */
@ApiModel("日志商品")
public class DCommodity<T extends DCommodity> extends FieldModel {

    @ApiModelProperty(value = "编号", name = "no")
    private Integer no;

    @ApiModelProperty(value = "系统唯一编号", name = "code")
    private Long code;

    @ApiModelProperty(value = "商品名称", name = "name")
    private String name;

    @ApiModelProperty(value = "单位", name = "unit")
    private String unit;

    @ApiModelProperty(value = "计件(量词)", name = "quantifier")
    private String quantifier;

    public DCommodity() {
    }

    // 计件使用
    public DCommodity(Integer no, Long code, String name, String quantifier) {
        this.no = no;
        this.code = code;
        this.name = name;
        this.unit = UnitEnum.计件.getVal();
        this.quantifier = quantifier;
    }

    // 计重使用
    public DCommodity(Integer no, Long code, String name, UnitEnum unit) {
        this.no = no;
        this.code = code;
        this.name = name;
        this.unit = unit.getVal();
    }

    public Integer getNo() {
        return no;
    }

    /**
     * @description: 编号
     **/
    @Override
    public Integer no() {
        return this.no;
    }

    public T setNo(Integer no) {
        this.no = no;
        return (T) this;
    }

    public Long getCode() {
        return code;
    }

    public T setCode(Long code) {
        this.code = code;
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public String getUnit() {
        return unit;
    }

    public T setUnit(String unit) {
        this.unit = unit;
        return (T) this;
    }

    public String getQuantifier() {
        return quantifier;
    }

    public T setQuantifier(String quantifier) {
        this.quantifier = quantifier;
        return (T) this;
    }
}
