package com.jhscale.common.model.device.log.inner;

import com.jhscale.common.ysscale.UnitEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: GPLU
 * @projectName common
 * @description: TODO
 * @date 2022/9/1716:36
 */
@ApiModel("日志PLU")
public class DPLUInfo extends DCommodity<DPLUInfo> {

    @ApiModelProperty(value = "库存类型", name = "inventoryType", example = "0|NULL-库存商品 1-非库存商品")
    private Integer inventoryType;

    public DPLUInfo() {
    }

    // 计件使用
    public DPLUInfo(Integer no, Long code, String name, String unitVal, Integer inventoryType) {
        super(no, code, name, unitVal);
        this.inventoryType = inventoryType;
    }

    // 计重使用
    public DPLUInfo(Integer no, Long code, String name, UnitEnum unit, Integer inventoryType) {
        super(no, code, name, unit);
        this.inventoryType = inventoryType;
    }

    public Integer getInventoryType() {
        return inventoryType;
    }

    public DPLUInfo setInventoryType(Integer inventoryType) {
        this.inventoryType = inventoryType;
        return this;
    }
}
