package com.jhscale.common.model.device.log.module;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.*;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: Goods
 * @projectName common
 * @description: TODO
 * @date 2022/9/1616:38
 */
@ApiModel("商品信息")
@DataClass
public class DGoods extends FieldModel {

    @ApiModelProperty(value = "PLU编号", name = "no")
    @ServerField(index = 1, length = 8, type = INT, must = true)
    @PublicField(index = 2, type = INT)
    private Integer no;

    @ApiModelProperty(value = "单位(1-计重|2-计件|3-kg|4-g|5-ton|6-lb|7-500g|8-100g|9-1/4lb)", name = "unit")
    @ServerField(index = 2, length = 2, type = INT, must = true)
    @PublicField(index = 7, type = INT)
    private Integer unit;

    @ApiModelProperty(value = "PLU名称", name = "name")
    @ServerField(index = 3, type = TXT, must = true)
    @PublicField(index = 14, type = TXT)
    private String name;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "数重量", name = "amount")
    @ServerField(index = 4, type = BDL, must = true)
    @PublicField(index = 6, type = BDL)
    private BigDecimal amount;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "单价", name = "price")
    @ServerField(index = 5, type = BDL, must = true)
    @PublicField(index = 13, type = BDL)
    private BigDecimal price;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "单计", name = "itemTotal")
    @ServerField(index = 6, type = BDL, must = true)
    @PublicField(index = 1, type = BDL)
    private BigDecimal itemTotal;


    @ApiModelProperty(value = "自定义量词(单位==2 && 单位业务参数 == 1|3 存在 默认:pcs)", name = "unitText")
    @ServerField(index = 7, type = TXT)
    private String unitText;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "库存数重量(计件取重使用)", name = "amountStock")
    @ServerField(index = 8, type = BDL)
    private BigDecimal amountStock;

    @ApiModelProperty(value = "库存单位(计件取重存在)", name = "unitStock")
    @ServerField(index = 9, length = 2, type = INT)
    private Integer unitStock;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "成本", name = "cost")
    @PublicField(index = 5, type = BDL)
    private BigDecimal cost;

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @ApiModelProperty(value = "税额", name = "tax")
    @ServerField(index = 10, type = BDL)
    @PublicField(index = 8, type = BDL)
    private BigDecimal tax;

    @ApiModelProperty(value = "分类（组）默认:9", name = "category")
    @ServerField(index = 11, length = 4, type = INT)
    @PublicField(index = 3, type = INT)
    private Integer category;

    @ApiModelProperty(value = "部门（默认9）", name = "dept")
    @ServerField(index = 12, length = 4, type = INT)
    @PublicField(index = 4, type = INT)
    private Integer dept;

    @ApiModelProperty(value = "文本1", name = "text1")
    @ServerField(index = 13, type = TXT)
    @PublicField(index = 9, type = TXT)
    private String text1;

    @ApiModelProperty(value = "文本2", name = "text2")
    @ServerField(index = 14, type = TXT)
    @PublicField(index = 10, type = TXT)
    private String text2;

    @ApiModelProperty(value = "文本3", name = "text3")
    @ServerField(index = 15, type = TXT)
    @PublicField(index = 11, type = TXT)
    private String text3;

    @ApiModelProperty(value = "文本4", name = "text4")
    @ServerField(index = 16, type = TXT)
    @PublicField(index = 12, type = TXT)
    private String text4;

    @ApiModelProperty(value = "日志类型（当条目的类型与总交易类型严重不符合时才有数值（在目前的版本中，可以认为不被使用））", name = "logType")
    @ServerField(index = 17, length = 4, type = INT)
    private Integer logType;

    @ApiModelProperty(value = "商品图片", name = "pics")
    @ServerField(index = 18, type = LST, list_type = TXT)
    private List<String> pics;

    /**
     * @description: 库存数重量
     **/
    public BigDecimal stockAmount() {
        return Objects.nonNull(this.amountStock) ? this.amountStock : this.amount;
    }

    /**
     * @description: 库存单位
     **/
    public Integer stockUnit() {
        return Objects.nonNull(this.unitStock) ? this.unitStock : this.unit;
    }

    public Integer category() {
        return Objects.nonNull(this.category) ? this.category : 9;
    }

    public Integer dept() {
        return Objects.nonNull(this.dept) ? this.dept : 9;
    }

    public BigDecimal tax() {
        return Objects.nonNull(this.tax) ? this.tax : new BigDecimal("0.00");
    }

    public BigDecimal cost() {
        return Objects.nonNull(this.cost) ? this.cost : new BigDecimal("0.00");
    }

    public BigDecimal price() {
        return Objects.nonNull(this.price) ? this.price : new BigDecimal("0.00");
    }

    public BigDecimal amount() {
        return Objects.nonNull(this.amount) ? this.amount : new BigDecimal("0.000");
    }

    public BigDecimal itemTotal() {
        return Objects.nonNull(this.itemTotal) ? this.itemTotal : new BigDecimal("0.00");
    }


    public Integer getNo() {
        return no;
    }

    /**
     * @description: 编号
     **/
    @Override
    public Integer no() {
        return this.no;
    }

    public DGoods setNo(Integer no) {
        this.no = no;
        return this;
    }

    public Integer getUnit() {
        return unit;
    }

    public DGoods setUnit(Integer unit) {
        this.unit = unit;
        return this;
    }

    public String getUnitText() {
        return unitText;
    }

    public DGoods setUnitText(String unitText) {
        this.unitText = unitText;
        return this;
    }

    public String getName() {
        return name;
    }

    public DGoods setName(String name) {
        this.name = name;
        return this;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public DGoods setAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public BigDecimal getAmountStock() {
        return amountStock;
    }

    public DGoods setAmountStock(BigDecimal amountStock) {
        this.amountStock = amountStock;
        return this;
    }

    public Integer getUnitStock() {
        return unitStock;
    }

    public DGoods setUnitStock(Integer unitStock) {
        this.unitStock = unitStock;
        return this;
    }

    public BigDecimal getCost() {
        return cost;
    }

    public DGoods setCost(BigDecimal cost) {
        this.cost = cost;
        return this;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public DGoods setPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    public BigDecimal getItemTotal() {
        return itemTotal;
    }

    public DGoods setItemTotal(BigDecimal itemTotal) {
        this.itemTotal = itemTotal;
        return this;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public DGoods setTax(BigDecimal tax) {
        this.tax = tax;
        return this;
    }

    public Integer getCategory() {
        return category;
    }

    public DGoods setCategory(Integer category) {
        this.category = category;
        return this;
    }

    public Integer getDept() {
        return dept;
    }

    public DGoods setDept(Integer dept) {
        this.dept = dept;
        return this;
    }

    public String getText1() {
        return text1;
    }

    public DGoods setText1(String text1) {
        this.text1 = text1;
        return this;
    }

    public String getText2() {
        return text2;
    }

    public DGoods setText2(String text2) {
        this.text2 = text2;
        return this;
    }

    public String getText3() {
        return text3;
    }

    public DGoods setText3(String text3) {
        this.text3 = text3;
        return this;
    }

    public String getText4() {
        return text4;
    }

    public DGoods setText4(String text4) {
        this.text4 = text4;
        return this;
    }

    public Integer getLogType() {
        return logType;
    }

    public DGoods setLogType(Integer logType) {
        this.logType = logType;
        return this;
    }

    public List<String> getPics() {
        return pics;
    }

    public DGoods setPics(List<String> pics) {
        this.pics = pics;
        return this;
    }
}
