package com.jhscale.common.model.device.log.module;

import com.jhscale.common.annotation.ServerField;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DSource
 * @projectName common
 * @description: TODO
 * @date 2022/9/209:40
 */
@ApiModel("原始来源")
public class DSource extends FieldModel {

    @ApiModelProperty(value = "终端编号", name = "no")
    @ServerField(index = 1, length = 8, type = INT, must = true)
    private Integer no;

    @ApiModelProperty(value = "设备序列号", name = "unique")
    @ServerField(index = 2, length = 2, type = TXT, must = true)
    private String unique;

    @ApiModelProperty(value = "交易时间", name = "tradeTime")
    @ServerField(index = 3, type = TME, must = true)
    private Date tradeTime;

    @ServerField(index = 4, length = 8, type = INT, must = true)
    private Integer fid;

    public DSource() {
    }

    public DSource(Integer fid) {
        this.fid = fid;
    }

    public String getUnique() {
        return unique;
    }

    public DSource setUnique(String unique) {
        this.unique = unique;
        return this;
    }

    public Date getTradeTime() {
        return tradeTime;
    }

    public DSource setTradeTime(Date tradeTime) {
        this.tradeTime = tradeTime;
        return this;
    }

    public Integer getNo() {
        return no;
    }

    /**
     * @description: 编号
     **/
    @Override
    public Integer no() {
        return this.no;
    }

    public DSource setNo(Integer no) {
        this.no = no;
        return this;
    }

    public Integer getFid() {
        return fid;
    }

    public DSource setFid(Integer fid) {
        this.fid = fid;
        return this;
    }
}
